/*
 * Decompiled with CFR 0.152.
 */
package io.reactivx.mantis.operators;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Action0;
import rx.internal.operators.NotificationLite;
import rx.subjects.Subject;
import rx.subscriptions.Subscriptions;

public final class BufferUntilSubscriber<T>
extends Subject<T, T> {
    static final Observer EMPTY_OBSERVER = new Observer(){

        public void onCompleted() {
        }

        public void onError(Throwable e) {
        }

        public void onNext(Object t) {
        }
    };
    final State<T> state;
    private boolean forward;

    private BufferUntilSubscriber(State<T> state) {
        super(new OnSubscribeAction<T>(state));
        this.state = state;
    }

    public static <T> BufferUntilSubscriber<T> create() {
        State state = new State();
        return new BufferUntilSubscriber(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emit(Object v) {
        Object object = this.state.guard;
        synchronized (object) {
            this.state.buffer.add(v);
            if (this.state.get() != null && !this.state.emitting) {
                this.forward = true;
                this.state.emitting = true;
            }
        }
        if (this.forward) {
            Object o;
            while ((o = this.state.buffer.poll()) != null) {
                NotificationLite.accept((Observer)((Observer)this.state.get()), (Object)o);
            }
        }
    }

    public void onCompleted() {
        if (this.forward) {
            ((Observer)this.state.get()).onCompleted();
        } else {
            this.emit(NotificationLite.completed());
        }
    }

    public void onError(Throwable e) {
        if (this.forward) {
            ((Observer)this.state.get()).onError(e);
        } else {
            this.emit(NotificationLite.error((Throwable)e));
        }
    }

    public void onNext(T t) {
        if (this.forward) {
            ((Observer)this.state.get()).onNext(t);
        } else {
            this.emit(NotificationLite.next(t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasObservers() {
        Object object = this.state.guard;
        synchronized (object) {
            return this.state.get() != null;
        }
    }

    static final class OnSubscribeAction<T>
    implements Observable.OnSubscribe<T> {
        final State<T> state;

        public OnSubscribeAction(State<T> state) {
            this.state = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void call(Subscriber<? super T> s) {
            if (this.state.casObserverRef(null, (Observer<? super T>)s)) {
                s.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        state.set(EMPTY_OBSERVER);
                    }
                }));
                boolean win = false;
                Object object = this.state.guard;
                synchronized (object) {
                    if (!this.state.emitting) {
                        this.state.emitting = true;
                        win = true;
                    }
                }
                if (win) {
                    while (true) {
                        Object o;
                        if ((o = this.state.buffer.poll()) != null) {
                            NotificationLite.accept((Observer)((Observer)this.state.get()), (Object)o);
                            continue;
                        }
                        Object object2 = this.state.guard;
                        synchronized (object2) {
                            if (this.state.buffer.isEmpty()) {
                                this.state.emitting = false;
                                break;
                            }
                        }
                    }
                }
            } else {
                s.onError((Throwable)new IllegalStateException("Only one subscriber allowed!"));
            }
        }
    }

    static final class State<T>
    extends AtomicReference<Observer<? super T>> {
        private static final long serialVersionUID = 8026705089538090368L;
        final Object guard = new Object();
        final ConcurrentLinkedQueue<Object> buffer = new ConcurrentLinkedQueue();
        boolean emitting;

        State() {
        }

        boolean casObserverRef(Observer<? super T> expected, Observer<? super T> next) {
            return this.compareAndSet(expected, next);
        }
    }
}

