/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.compression;

import io.mantisrx.common.MantisServerSentEvent;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;

public class CompressionUtils {
    public static final String MANTIS_SSE_DELIMITER = "$$$";
    public static final byte[] MANTIS_SSE_DELIMITER_BINARY = "$$$".getBytes();
    private static Logger logger = LoggerFactory.getLogger(CompressionUtils.class);

    public static String compressAndBase64Encode(List<String> events, boolean useSnappy) {
        return CompressionUtils.compressAndBase64Encode(events, useSnappy, MANTIS_SSE_DELIMITER_BINARY);
    }

    public static String compressAndBase64Encode(List<String> events, boolean useSnappy, byte[] delimiter) {
        if (!events.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String event : events) {
                sb.append(event);
                sb.append(delimiter);
            }
            try {
                byte[] compressedBytes = useSnappy ? CompressionUtils.snappyCompressData(sb.toString()) : CompressionUtils.gzipCompressData(sb.toString());
                String encodedData = Base64.getEncoder().encodeToString(compressedBytes);
                if (logger.isDebugEnabled()) {
                    logger.debug("Encoded Data --> " + encodedData);
                }
                return encodedData;
            }
            catch (UnsupportedEncodingException e) {
                logger.warn("Error encoding messages:" + e.getMessage());
            }
            catch (IOException e) {
                logger.warn("Error encoding messages2:" + e.getMessage());
            }
        }
        return null;
    }

    public static String compressAndBase64Encode(List<String> events) {
        return CompressionUtils.compressAndBase64Encode(events, false);
    }

    public static byte[] compressAndBase64EncodeBytes(List<List<byte[]>> nestedEvents, boolean useSnappy) {
        return CompressionUtils.compressAndBase64EncodeBytes(nestedEvents, useSnappy, MANTIS_SSE_DELIMITER_BINARY);
    }

    public static byte[] compressAndBase64EncodeBytes(List<List<byte[]>> nestedEvents, boolean useSnappy, byte[] delimiter) {
        if (!nestedEvents.isEmpty()) {
            ByteBuffer buffer = ByteBuffer.allocate(CompressionUtils.getTotalByteSize(nestedEvents, delimiter));
            for (List<byte[]> outerList : nestedEvents) {
                for (byte[] event : outerList) {
                    buffer.put(event);
                    buffer.put(delimiter);
                }
            }
            try {
                byte[] compressedBytes = useSnappy ? CompressionUtils.snappyCompressData(buffer.array()) : CompressionUtils.gzipCompressData(buffer.array());
                String encodedData = Base64.getEncoder().encodeToString(compressedBytes);
                if (logger.isDebugEnabled()) {
                    logger.debug("Encoded Data --> " + encodedData);
                }
                return encodedData.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.warn("Error encoding messages:" + e.getMessage());
            }
            catch (IOException e) {
                logger.warn("Error encoding messages2:" + e.getMessage());
            }
        }
        return null;
    }

    @Deprecated
    public static byte[] compressAndBase64EncodeBytes(List<List<byte[]>> nestedEvents) {
        if (!nestedEvents.isEmpty()) {
            ByteBuffer buffer = ByteBuffer.allocate(CompressionUtils.getTotalByteSize(nestedEvents, MANTIS_SSE_DELIMITER_BINARY));
            for (List<byte[]> outerList : nestedEvents) {
                for (byte[] event : outerList) {
                    buffer.put(event);
                    buffer.put(MANTIS_SSE_DELIMITER_BINARY);
                }
            }
            try {
                byte[] compressedBytes = CompressionUtils.gzipCompressData(buffer.array());
                String encodedData = Base64.getEncoder().encodeToString(compressedBytes);
                if (logger.isDebugEnabled()) {
                    logger.debug("Encoded Data --> " + encodedData);
                }
                return encodedData.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.warn("Error encoding messages:" + e.getMessage());
            }
            catch (IOException e) {
                logger.warn("Error encoding messages2:" + e.getMessage());
            }
        }
        return null;
    }

    private static int getTotalByteSize(List<List<byte[]>> nestedEvents, byte[] delimiter) {
        int size = 0;
        int count = 0;
        for (List<byte[]> outerList : nestedEvents) {
            for (byte[] event : outerList) {
                ++count;
                size += event.length;
            }
        }
        return size + count * delimiter.length;
    }

    public static List<MantisServerSentEvent> decompressAndBase64Decode_old(String encodedString, boolean isCompressedBinary) {
        if (!(encodedString = encodedString.trim()).isEmpty() && isCompressedBinary && !encodedString.startsWith("ping") && !encodedString.startsWith("{")) {
            if (logger.isDebugEnabled()) {
                logger.debug("decoding " + encodedString);
            }
            byte[] decoded = Base64.getDecoder().decode(encodedString);
            try {
                String line;
                GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(decoded));
                BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gis, "UTF-8"));
                String outStr = "";
                while ((line = bf.readLine()) != null) {
                    outStr = outStr + line;
                }
                String[] toks = outStr.split("\\$\\$\\$");
                ArrayList<MantisServerSentEvent> msseList = new ArrayList<MantisServerSentEvent>();
                for (String tok : toks) {
                    msseList.add(new MantisServerSentEvent(tok));
                }
                return msseList;
            }
            catch (IOException e) {
                logger.error(e.getMessage());
                return new ArrayList<MantisServerSentEvent>();
            }
        }
        ArrayList<MantisServerSentEvent> s = new ArrayList<MantisServerSentEvent>();
        s.add(new MantisServerSentEvent(encodedString));
        return s;
    }

    static List<MantisServerSentEvent> tokenize(BufferedReader br) throws IOException {
        return CompressionUtils.tokenize(br, MANTIS_SSE_DELIMITER);
    }

    static List<MantisServerSentEvent> tokenize(BufferedReader bf, String delimiter) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        ArrayList<MantisServerSentEvent> msseList = new ArrayList<MantisServerSentEvent>();
        int delimiterLength = delimiter.length();
        char[] delimiterArray = delimiter.toCharArray();
        int delimiterCount = 0;
        while ((line = bf.readLine()) != null) {
            for (int i = 0; i < line.length(); ++i) {
                if (line.charAt(i) != delimiterArray[delimiterCount]) {
                    if (delimiterCount > 0) {
                        for (int j = 0; j < delimiterCount; ++j) {
                            sb.append(delimiterArray[j]);
                        }
                        delimiterCount = 0;
                    }
                    if (line.charAt(i) != delimiterArray[delimiterCount]) {
                        sb.append(line.charAt(i));
                    } else {
                        ++delimiterCount;
                    }
                } else {
                    ++delimiterCount;
                }
                if (delimiterCount != delimiterLength) continue;
                msseList.add(new MantisServerSentEvent(sb.toString()));
                delimiterCount = 0;
                sb = new StringBuilder();
            }
        }
        if (sb.length() > 0) {
            if (delimiterCount > 0) {
                for (int j = 0; j < delimiterCount; ++j) {
                    sb.append(delimiter.charAt(j));
                }
            }
            msseList.add(new MantisServerSentEvent(sb.toString()));
        }
        return msseList;
    }

    static List<MantisServerSentEvent> tokenize_1(BufferedReader bf) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        ArrayList<MantisServerSentEvent> msseList = new ArrayList<MantisServerSentEvent>();
        String outStr = "";
        while ((line = bf.readLine()) != null) {
            sb.append(line);
        }
        int i = 0;
        outStr = sb.toString();
        sb = new StringBuilder();
        while (i < outStr.length()) {
            while (outStr.charAt(i) != '$') {
                sb.append(outStr.charAt(i));
                ++i;
            }
            if (i + 3 < outStr.length()) {
                if (outStr.charAt(i) != '$' || outStr.charAt(i + 1) != '$' || outStr.charAt(i + 2) != '$') continue;
                i += 3;
                msseList.add(new MantisServerSentEvent(sb.toString()));
                sb = new StringBuilder();
                continue;
            }
            sb.append(outStr.charAt(i));
            ++i;
        }
        return msseList;
    }

    static List<MantisServerSentEvent> tokenize_2(BufferedReader bf) throws IOException {
        String[] toks;
        String line;
        StringBuilder sb = new StringBuilder();
        ArrayList<MantisServerSentEvent> msseList = new ArrayList<MantisServerSentEvent>();
        String outStr = "";
        while ((line = bf.readLine()) != null) {
            sb.append(line);
        }
        outStr = sb.toString();
        for (String tok : toks = outStr.split("\\$\\$\\$")) {
            msseList.add(new MantisServerSentEvent(tok));
        }
        return msseList;
    }

    public static List<MantisServerSentEvent> decompressAndBase64Decode(String encodedString, boolean isCompressedBinary, boolean useSnappy) {
        return CompressionUtils.decompressAndBase64Decode(encodedString, isCompressedBinary, useSnappy, null);
    }

    public static List<MantisServerSentEvent> decompressAndBase64Decode(String encodedString, boolean isCompressedBinary, boolean useSnappy, String delimiter) {
        if (!(encodedString = encodedString.trim()).isEmpty() && isCompressedBinary && !encodedString.startsWith("ping") && !encodedString.startsWith("{")) {
            if (logger.isDebugEnabled()) {
                logger.debug("decoding " + encodedString);
            }
            byte[] decoded = Base64.getDecoder().decode(encodedString);
            try {
                if (useSnappy) {
                    return delimiter == null ? CompressionUtils.tokenize(CompressionUtils.snappyDecompress(decoded)) : CompressionUtils.tokenize(CompressionUtils.snappyDecompress(decoded), delimiter);
                }
                return delimiter == null ? CompressionUtils.tokenize(CompressionUtils.gzipDecompress(decoded)) : CompressionUtils.tokenize(CompressionUtils.gzipDecompress(decoded), delimiter);
            }
            catch (IOException e) {
                logger.error(e.getMessage());
                return new ArrayList<MantisServerSentEvent>();
            }
        }
        ArrayList<MantisServerSentEvent> s = new ArrayList<MantisServerSentEvent>();
        s.add(new MantisServerSentEvent(encodedString));
        return s;
    }

    @Deprecated
    public static List<MantisServerSentEvent> decompressAndBase64Decode(String encodedString, boolean isCompressedBinary) {
        return CompressionUtils.decompressAndBase64Decode(encodedString, isCompressedBinary, false);
    }

    static byte[] snappyCompressData(String data) throws IOException {
        return Snappy.compress((String)data);
    }

    static byte[] snappyCompressData(byte[] data) throws IOException {
        return Snappy.compress((byte[])data);
    }

    static byte[] gzipCompressData(String data) throws IOException, UnsupportedEncodingException {
        ByteArrayOutputStream obj = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(obj);
        gzip.write(data.getBytes("UTF-8"));
        gzip.close();
        byte[] compressedBytes = obj.toByteArray();
        return compressedBytes;
    }

    static byte[] gzipCompressData(byte[] data) throws IOException, UnsupportedEncodingException {
        ByteArrayOutputStream obj = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(obj);
        gzip.write(data);
        gzip.close();
        byte[] compressedBytes = obj.toByteArray();
        return compressedBytes;
    }

    static BufferedReader snappyDecompress(byte[] data) throws IOException {
        byte[] decompressed = Snappy.uncompress((byte[])data);
        ByteArrayInputStream bais = new ByteArrayInputStream(decompressed);
        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)bais, "UTF-8"));
        return bf;
    }

    static BufferedReader gzipDecompress(byte[] data) throws IOException {
        GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(data));
        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gis, "UTF-8"));
        return bf;
    }

    public static void main(String[] args) {
        String d = "{\"ip\":\"50.112.119.64\",\"count\":27}$$${\\\"ip\\\":\\\"50.112.119.64\\\",\\\"count\\\":27}";
        String e1 = "{\"ip\":\"11.112.119.64\",\"count\":27}";
        String e2 = "{\"ip\":\"22.111.112.62\",\"count\":27}";
        String e3 = "{\"ip\":\"33.222.112.62\",\"count\":27}";
        ArrayList<String> events = new ArrayList<String>();
        events.add(e1);
        events.add(e2);
        events.add(e3);
        String encodedString = CompressionUtils.compressAndBase64Encode(events);
        List<MantisServerSentEvent> orig = CompressionUtils.decompressAndBase64Decode(encodedString, true);
        for (MantisServerSentEvent event : orig) {
            System.out.println("event -> " + event);
        }
    }
}

