/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.descriptor;

import io.mantisrx.runtime.JobConstraints;
import io.mantisrx.runtime.MachineDefinition;
import io.mantisrx.runtime.descriptor.StageScalingPolicy;
import io.mantisrx.runtime.descriptor.StageSchedulingInfo;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class SchedulingInfo {
    private Map<Integer, StageSchedulingInfo> stages = new HashMap<Integer, StageSchedulingInfo>();

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public SchedulingInfo(@JsonProperty(value="stages") Map<Integer, StageSchedulingInfo> stages) {
        this.stages = stages;
    }

    @JsonIgnore
    SchedulingInfo(Builder builder) {
        this.stages.putAll(builder.builderStages);
    }

    public static void main(String[] args) {
        HashMap<StageScalingPolicy.ScalingReason, StageScalingPolicy.Strategy> smap = new HashMap<StageScalingPolicy.ScalingReason, StageScalingPolicy.Strategy>();
        smap.put(StageScalingPolicy.ScalingReason.Memory, new StageScalingPolicy.Strategy(StageScalingPolicy.ScalingReason.Memory, 0.1, 0.6, null));
        Builder builder = new Builder().numberOfStages(2).multiWorkerScalableStageWithConstraints(2, new MachineDefinition(1.0, 1.24, 0.0, 1.0, 1), null, null, new StageScalingPolicy(1, 1, 3, 1, 1, 60L, smap)).multiWorkerScalableStageWithConstraints(3, new MachineDefinition(1.0, 1.24, 0.0, 1.0, 1), null, null, new StageScalingPolicy(1, 1, 3, 1, 1, 60L, smap));
        ObjectMapper mapper = new ObjectMapper();
        try {
            System.out.println(mapper.writeValueAsString((Object)builder.build()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Map<Integer, StageSchedulingInfo> getStages() {
        return this.stages;
    }

    public void addJobMasterStage(StageSchedulingInfo schedulingInfo) {
        this.stages.put(0, schedulingInfo);
    }

    public StageSchedulingInfo forStage(int stageNum) {
        return this.stages.get(stageNum);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchedulingInfo)) {
            return false;
        }
        SchedulingInfo other = (SchedulingInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Integer, StageSchedulingInfo> this$stages = this.getStages();
        Map<Integer, StageSchedulingInfo> other$stages = other.getStages();
        return !(this$stages == null ? other$stages != null : !((Object)this$stages).equals(other$stages));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchedulingInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Integer, StageSchedulingInfo> $stages = this.getStages();
        result = result * 59 + ($stages == null ? 43 : ((Object)$stages).hashCode());
        return result;
    }

    public String toString() {
        return "SchedulingInfo(stages=" + this.getStages() + ")";
    }

    public static class Builder {
        private final Map<Integer, StageSchedulingInfo> builderStages = new HashMap<Integer, StageSchedulingInfo>();
        private Integer currentStage = 1;
        private int numberOfStages;

        public Builder addStage(StageSchedulingInfo stageSchedulingInfo) {
            this.builderStages.put(this.currentStage, stageSchedulingInfo);
            Integer n = this.currentStage;
            Integer n2 = this.currentStage = Integer.valueOf(this.currentStage + 1);
            return this;
        }

        public void addJobMasterStage(StageSchedulingInfo schedulingInfo) {
            this.builderStages.put(0, schedulingInfo);
        }

        public Builder numberOfStages(int numberOfStages) {
            this.numberOfStages = numberOfStages;
            return this;
        }

        public Builder singleWorkerStageWithConstraints(MachineDefinition machineDefinition, List<JobConstraints> hardConstraints, List<JobConstraints> softConstraints) {
            return this.addStage(StageSchedulingInfo.builder().numberOfInstances(1).machineDefinition(machineDefinition).hardConstraints(hardConstraints).softConstraints(softConstraints).build());
        }

        public Builder singleWorkerStage(MachineDefinition machineDefinition) {
            return this.addStage(StageSchedulingInfo.builder().numberOfInstances(1).machineDefinition(machineDefinition).build());
        }

        public Builder multiWorkerScalableStageWithConstraints(int numberOfWorkers, MachineDefinition machineDefinition, List<JobConstraints> hardConstraints, List<JobConstraints> softConstraints, StageScalingPolicy scalingPolicy) {
            StageScalingPolicy ssp = new StageScalingPolicy(this.currentStage, scalingPolicy.getMin(), scalingPolicy.getMax(), scalingPolicy.getIncrement(), scalingPolicy.getDecrement(), scalingPolicy.getCoolDownSecs(), scalingPolicy.getStrategies());
            return this.addStage(StageSchedulingInfo.builder().numberOfInstances(numberOfWorkers).machineDefinition(machineDefinition).hardConstraints(hardConstraints).softConstraints(softConstraints).scalingPolicy(ssp).scalable(ssp.isEnabled()).build());
        }

        public Builder multiWorkerStageWithConstraints(int numberOfWorkers, MachineDefinition machineDefinition, List<JobConstraints> hardConstraints, List<JobConstraints> softConstraints) {
            return this.addStage(StageSchedulingInfo.builder().numberOfInstances(numberOfWorkers).machineDefinition(machineDefinition).hardConstraints(hardConstraints).softConstraints(softConstraints).build());
        }

        public Builder multiWorkerStage(int numberOfWorkers, MachineDefinition machineDefinition) {
            return this.multiWorkerStage(numberOfWorkers, machineDefinition, false);
        }

        public Builder multiWorkerStage(int numberOfWorkers, MachineDefinition machineDefinition, boolean scalable) {
            return this.addStage(StageSchedulingInfo.builder().numberOfInstances(numberOfWorkers).machineDefinition(machineDefinition).scalable(scalable).build());
        }

        public Builder createWithInstanceInheritance(Map<Integer, StageSchedulingInfo> givenStages, Function<Integer, Optional<Integer>> getInstanceCountForStage, Function<Integer, Boolean> inheritEnabled, boolean forceInheritance) {
            this.numberOfStages(givenStages.size());
            givenStages.keySet().stream().sorted().forEach(k -> {
                Optional prevCntO = (Optional)getInstanceCountForStage.apply((Integer)k);
                StageSchedulingInfo resStage = (StageSchedulingInfo)givenStages.get(k);
                if (prevCntO.isPresent() && (forceInheritance || ((Boolean)inheritEnabled.apply((Integer)k)).booleanValue())) {
                    resStage = ((StageSchedulingInfo)givenStages.get(k)).toBuilder().numberOfInstances((Integer)prevCntO.get()).build();
                }
                if (k == 0) {
                    this.addJobMasterStage(resStage);
                } else {
                    this.addStage(resStage);
                }
            });
            return this;
        }

        public SchedulingInfo build() {
            if (this.numberOfStages == 0) {
                throw new IllegalArgumentException("Number of stages is 0, must be specified using builder.");
            }
            if (this.numberOfStages != this.builderStages.size()) {
                throw new IllegalArgumentException("Missing scheduling information, number of stages: " + this.numberOfStages + " configured stages: " + this.builderStages.size());
            }
            return new SchedulingInfo(this);
        }
    }
}

