/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.descriptor;

import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StageScalingPolicy {
    private final int stage;
    private final int min;
    private final int max;
    private final boolean enabled;
    private final int increment;
    private final int decrement;
    private final long coolDownSecs;
    private final Map<ScalingReason, Strategy> strategies;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public StageScalingPolicy(@JsonProperty(value="stage") int stage, @JsonProperty(value="min") int min, @JsonProperty(value="max") int max, @JsonProperty(value="increment") int increment, @JsonProperty(value="decrement") int decrement, @JsonProperty(value="coolDownSecs") long coolDownSecs, @JsonProperty(value="strategies") Map<ScalingReason, Strategy> strategies) {
        this.stage = stage;
        this.min = min;
        this.max = Math.max(max, min);
        this.enabled = min != max && strategies != null && !strategies.isEmpty();
        this.increment = Math.max(increment, 1);
        this.decrement = Math.max(decrement, 1);
        this.coolDownSecs = coolDownSecs;
        this.strategies = strategies == null ? new HashMap<ScalingReason, Strategy>() : new HashMap<ScalingReason, Strategy>(strategies);
    }

    public static void main(String[] args) {
        HashMap<ScalingReason, Strategy> smap = new HashMap<ScalingReason, Strategy>();
        smap.put(ScalingReason.CPU, new Strategy(ScalingReason.CPU, 0.5, 0.75, null));
        smap.put(ScalingReason.DataDrop, new Strategy(ScalingReason.DataDrop, 0.0, 2.0, null));
        StageScalingPolicy policy = new StageScalingPolicy(1, 1, 2, 1, 1, 60L, smap);
        ObjectMapper mapper = new ObjectMapper();
        try {
            System.out.println(mapper.writeValueAsString((Object)policy));
            String json1 = "{\"stage\":1,\"min\":1,\"max\":2,\"increment\":1,\"decrement\":1,\"strategies\":{},\"enabled\":false}";
            StageScalingPolicy sp = (StageScalingPolicy)mapper.readValue(json1, StageScalingPolicy.class);
            String json2 = "{\"stage\":1,\"min\":1,\"max\":5,\"increment\":1,\"decrement\":1,\"coolDownSecs\":600,\"strategies\":{\"CPU\":{\"reason\":\"CPU\",\"scaleDownBelowPct\":50,\"scaleUpAbovePct\":75}},\"enabled\":true}";
            sp = (StageScalingPolicy)mapper.readValue(json2, StageScalingPolicy.class);
            System.out.println(mapper.writeValueAsString((Object)sp));
            String json3 = "{\"stage\":1,\"min\":1,\"max\":3,\"increment\":1,\"decrement\":1,\"coolDownSecs\":0,\"strategies\":{\"Memory\":{\"reason\":\"Memory\",\"scaleDownBelowPct\":65,\"scaleUpAbovePct\":80,\"rollingCount\":{\"count\":6,\"of\":10}}},\"enabled\":true}";
            sp = (StageScalingPolicy)mapper.readValue(json3, StageScalingPolicy.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getStage() {
        return this.stage;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getIncrement() {
        return this.increment;
    }

    public int getDecrement() {
        return this.decrement;
    }

    public long getCoolDownSecs() {
        return this.coolDownSecs;
    }

    public Map<ScalingReason, Strategy> getStrategies() {
        return Collections.unmodifiableMap(this.strategies);
    }

    public String toString() {
        return "StageScalingPolicy{stage=" + this.stage + ", min=" + this.min + ", max=" + this.max + ", enabled=" + this.enabled + ", increment=" + this.increment + ", decrement=" + this.decrement + ", coolDownSecs=" + this.coolDownSecs + ", strategies=" + this.strategies + '}';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.coolDownSecs ^ this.coolDownSecs >>> 32);
        result = 31 * result + this.decrement;
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + this.increment;
        result = 31 * result + this.max;
        result = 31 * result + this.min;
        result = 31 * result + this.stage;
        result = 31 * result + (this.strategies == null ? 0 : this.strategies.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StageScalingPolicy other = (StageScalingPolicy)obj;
        if (this.coolDownSecs != other.coolDownSecs) {
            return false;
        }
        if (this.decrement != other.decrement) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.increment != other.increment) {
            return false;
        }
        if (this.max != other.max) {
            return false;
        }
        if (this.min != other.min) {
            return false;
        }
        if (this.stage != other.stage) {
            return false;
        }
        return !(this.strategies == null ? other.strategies != null : !this.strategies.equals(other.strategies));
    }

    public static class Strategy {
        private final ScalingReason reason;
        private final double scaleDownBelowPct;
        private final double scaleUpAbovePct;
        private final RollingCount rollingCount;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public Strategy(@JsonProperty(value="reason") ScalingReason reason, @JsonProperty(value="scaleDownBelowPct") double scaleDownBelowPct, @JsonProperty(value="scaleUpAbovePct") double scaleUpAbovePct, @JsonProperty(value="rollingCount") RollingCount rollingCount) {
            this.reason = reason;
            this.scaleDownBelowPct = scaleDownBelowPct;
            this.scaleUpAbovePct = Math.max(scaleDownBelowPct, scaleUpAbovePct);
            this.rollingCount = rollingCount == null ? new RollingCount(1, 1) : rollingCount;
        }

        public ScalingReason getReason() {
            return this.reason;
        }

        public double getScaleDownBelowPct() {
            return this.scaleDownBelowPct;
        }

        public double getScaleUpAbovePct() {
            return this.scaleUpAbovePct;
        }

        public RollingCount getRollingCount() {
            return this.rollingCount;
        }

        public String toString() {
            return "Strategy{reason=" + (Object)((Object)this.reason) + ", scaleDownBelowPct=" + this.scaleDownBelowPct + ", scaleUpAbovePct=" + this.scaleUpAbovePct + ", rollingCount=" + this.rollingCount + '}';
        }
    }

    public static class RollingCount {
        private final int count;
        private final int of;

        @JsonCreator
        public RollingCount(@JsonProperty(value="count") int count, @JsonProperty(value="of") int of) {
            this.count = count;
            this.of = of;
        }

        public int getCount() {
            return this.count;
        }

        public int getOf() {
            return this.of;
        }

        public String toString() {
            return "RollingCount{count=" + this.count + ", of=" + this.of + '}';
        }
    }

    public static enum ScalingReason {
        CPU,
        Memory,
        Network,
        DataDrop,
        KafkaLag,
        UserDefined,
        KafkaProcessed,
        Clutch,
        ClutchExperimental,
        RPS,
        JVMMemory;

    }
}

