/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.descriptor;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.runtime.JobConstraints;
import io.mantisrx.runtime.MachineDefinition;
import io.mantisrx.runtime.descriptor.StageScalingPolicy;
import io.mantisrx.runtime.descriptor.StageSchedulingInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SchedulingInfo {
    private Map<Integer, StageSchedulingInfo> stages = new HashMap<Integer, StageSchedulingInfo>();

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public SchedulingInfo(@JsonProperty(value="stages") Map<Integer, StageSchedulingInfo> stages) {
        this.stages = stages;
    }

    @JsonIgnore
    SchedulingInfo(Builder builder) {
        this.stages.putAll(builder.builderStages);
    }

    public static void main(String[] args) {
        HashMap<StageScalingPolicy.ScalingReason, StageScalingPolicy.Strategy> smap = new HashMap<StageScalingPolicy.ScalingReason, StageScalingPolicy.Strategy>();
        smap.put(StageScalingPolicy.ScalingReason.Memory, new StageScalingPolicy.Strategy(StageScalingPolicy.ScalingReason.Memory, 0.1, 0.6, null));
        Builder builder = new Builder().numberOfStages(2).multiWorkerScalableStageWithConstraints(2, new MachineDefinition(1.0, 1.24, 0.0, 1.0, 1), null, null, new StageScalingPolicy(1, 1, 3, 1, 1, 60L, smap)).multiWorkerScalableStageWithConstraints(3, new MachineDefinition(1.0, 1.24, 0.0, 1.0, 1), null, null, new StageScalingPolicy(1, 1, 3, 1, 1, 60L, smap));
        ObjectMapper mapper = new ObjectMapper();
        try {
            System.out.println(mapper.writeValueAsString((Object)builder.build()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchedulingInfo that = (SchedulingInfo)o;
        return Objects.equals(this.stages, that.stages);
    }

    public int hashCode() {
        return Objects.hash(this.stages);
    }

    public Map<Integer, StageSchedulingInfo> getStages() {
        return this.stages;
    }

    public void addJobMasterStage(StageSchedulingInfo schedulingInfo) {
        this.stages.put(0, schedulingInfo);
    }

    public StageSchedulingInfo forStage(int stageNum) {
        return this.stages.get(stageNum);
    }

    public String toString() {
        return "SchedulingInfo{stages=" + this.stages + '}';
    }

    public static class Builder {
        private Map<Integer, StageSchedulingInfo> builderStages = new HashMap<Integer, StageSchedulingInfo>();
        private Integer currentStage = 1;
        private int numberOfStages;

        public Builder numberOfStages(int numberOfStages) {
            this.numberOfStages = numberOfStages;
            return this;
        }

        public Builder singleWorkerStageWithConstraints(MachineDefinition machineDefinition, List<JobConstraints> hardConstraints, List<JobConstraints> softConstraints) {
            this.builderStages.put(this.currentStage, new StageSchedulingInfo(1, machineDefinition, hardConstraints, softConstraints, null, false));
            Integer n = this.currentStage;
            Integer n2 = this.currentStage = Integer.valueOf(this.currentStage + 1);
            return this;
        }

        public Builder singleWorkerStage(MachineDefinition machineDefinition) {
            this.builderStages.put(this.currentStage, new StageSchedulingInfo(1, machineDefinition, null, null, null, false));
            Integer n = this.currentStage;
            Integer n2 = this.currentStage = Integer.valueOf(this.currentStage + 1);
            return this;
        }

        public Builder multiWorkerScalableStageWithConstraints(int numberOfWorkers, MachineDefinition machineDefinition, List<JobConstraints> hardConstraints, List<JobConstraints> softConstraints, StageScalingPolicy scalingPolicy) {
            StageScalingPolicy ssp = new StageScalingPolicy(this.currentStage, scalingPolicy.getMin(), scalingPolicy.getMax(), scalingPolicy.getIncrement(), scalingPolicy.getDecrement(), scalingPolicy.getCoolDownSecs(), scalingPolicy.getStrategies());
            this.builderStages.put(this.currentStage, new StageSchedulingInfo(numberOfWorkers, machineDefinition, hardConstraints, softConstraints, ssp, ssp.isEnabled()));
            Integer n = this.currentStage;
            Integer n2 = this.currentStage = Integer.valueOf(this.currentStage + 1);
            return this;
        }

        public Builder multiWorkerStageWithConstraints(int numberOfWorkers, MachineDefinition machineDefinition, List<JobConstraints> hardConstraints, List<JobConstraints> softConstraints) {
            this.builderStages.put(this.currentStage, new StageSchedulingInfo(numberOfWorkers, machineDefinition, hardConstraints, softConstraints, null, false));
            Integer n = this.currentStage;
            Integer n2 = this.currentStage = Integer.valueOf(this.currentStage + 1);
            return this;
        }

        public Builder multiWorkerStage(int numberOfWorkers, MachineDefinition machineDefinition) {
            this.builderStages.put(this.currentStage, new StageSchedulingInfo(numberOfWorkers, machineDefinition, null, null, null, false));
            Integer n = this.currentStage;
            Integer n2 = this.currentStage = Integer.valueOf(this.currentStage + 1);
            return this;
        }

        public SchedulingInfo build() {
            if (this.numberOfStages == 0) {
                throw new IllegalArgumentException("Number of stages is 0, must be specified using builder.");
            }
            if (this.numberOfStages != this.builderStages.size()) {
                throw new IllegalArgumentException("Missing scheduling information, number of stages: " + this.numberOfStages + " configured stages: " + this.builderStages.size());
            }
            return new SchedulingInfo(this);
        }
    }
}

