/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common;

import io.mantisrx.shaded.com.fasterxml.jackson.core.type.TypeReference;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.Module;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import io.mantisrx.shaded.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.IOException;
import java.util.Map;

public class JsonSerializer {
    private static final ObjectMapper defaultObjectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).registerModule((Module)new Jdk8Module());
    public static final SimpleFilterProvider DEFAULT_FILTER_PROVIDER = new SimpleFilterProvider();

    public <T> T fromJSON(String json, Class<T> expectedType) throws IOException {
        return (T)defaultObjectMapper.readerFor(expectedType).readValue(json);
    }

    public <T> T fromJson(byte[] json, Class<T> expectedType) throws IOException {
        return (T)defaultObjectMapper.readValue(json, expectedType);
    }

    public <T> T fromJSON(String json, TypeReference<T> expectedType) throws IOException {
        return (T)defaultObjectMapper.readerFor(expectedType).readValue(json);
    }

    public String toJson(Object object) throws IOException {
        return defaultObjectMapper.writeValueAsString(object);
    }

    public byte[] toJsonBytes(Object object) throws IOException {
        return defaultObjectMapper.writeValueAsBytes(object);
    }

    public Map<String, Object> toMap(String json) throws IOException {
        return (Map)defaultObjectMapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    static {
        DEFAULT_FILTER_PROVIDER.setFailOnUnknownId(false);
    }
}

