/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.client;

import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import io.mantisrx.client.MantisClient;
import io.mantisrx.server.core.JobSchedulingInfo;
import io.mantisrx.server.core.WorkerAssignments;
import io.mantisrx.server.master.client.MantisMasterGateway;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func1;

public class StageWorkersCount {
    @Argument(alias="p", description="Specify a configuration file", required=true)
    private static String propFile = "";
    @Argument(alias="j", description="Specify job Id", required=true)
    private static String jobIdString = "";
    private final String jobId;
    private final MantisClient mantisClient;

    public StageWorkersCount(String jobId, MantisClient mantisClient) {
        this.jobId = jobId;
        this.mantisClient = mantisClient;
    }

    public static void main(String[] args) {
        try {
            Args.parse(StageWorkersCount.class, (String[])args);
        }
        catch (IllegalArgumentException e) {
            Args.usage(StageWorkersCount.class);
            System.exit(1);
        }
        Properties properties = new Properties();
        System.out.println("propfile=" + propFile);
        try (FileInputStream inputStream = new FileInputStream(propFile);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StageWorkersCount workersCount = new StageWorkersCount(jobIdString, new MantisClient(properties));
        workersCount.getWorkerCounts(1).subscribe((Subscriber)new Subscriber<Integer>(){

            public void onCompleted() {
                System.out.println("Completed");
                System.exit(0);
            }

            public void onError(Throwable e) {
                System.err.println("Unexpected error: " + e.getMessage());
                e.printStackTrace();
            }

            public void onNext(Integer integer) {
                System.out.println("#Workers changed to " + integer);
            }
        });
        try {
            Thread.sleep(10000000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    Observable<Integer> getWorkerCounts(final int stageNumber) {
        final AtomicInteger workerCount = new AtomicInteger(0);
        final AtomicBoolean gotCompletion = new AtomicBoolean(false);
        return this.mantisClient.getClientWrapper().getMasterClientApi().flatMap((Func1)new Func1<MantisMasterGateway, Observable<Integer>>(){

            public Observable<Integer> call(MantisMasterGateway mantisMasterClientApi) {
                return mantisMasterClientApi.schedulingChanges(StageWorkersCount.this.jobId).map((Func1)new Func1<JobSchedulingInfo, Integer>(){

                    public Integer call(JobSchedulingInfo jobSchedulingInfo) {
                        WorkerAssignments assignments = (WorkerAssignments)jobSchedulingInfo.getWorkerAssignments().get(stageNumber);
                        if (assignments == null) {
                            return -1;
                        }
                        return assignments.getNumWorkers();
                    }
                }).filter((Func1)new Func1<Integer, Boolean>(){

                    public Boolean call(Integer newCount) {
                        if (newCount.intValue() == workerCount.get()) {
                            return false;
                        }
                        workerCount.set(newCount);
                        return true;
                    }
                }).doOnCompleted(new Action0(){

                    public void call() {
                        gotCompletion.set(true);
                    }
                });
            }
        }).takeWhile((Func1)new Func1<Integer, Boolean>(){

            public Boolean call(Integer integer) {
                return !gotCompletion.get();
            }
        });
    }
}

