/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.client.examples;

import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import io.mantisrx.client.MantisClient;
import io.mantisrx.runtime.MantisJobState;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class GetJobsList {
    @Argument(alias="p", description="Specify a configuration file", required=true)
    private static String propFile = "";
    @Argument(alias="n", description="Job name for getting list", required=true)
    private static String jobName;

    public static void main(String[] args) {
        try {
            Args.parse(GetJobsList.class, (String[])args);
        }
        catch (IllegalArgumentException e) {
            Args.usage(GetJobsList.class);
            System.exit(1);
        }
        System.out.println("propfile=" + propFile);
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(propFile);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MantisClient mantisClient = new MantisClient(properties);
        String json = (String)mantisClient.getJobsOfNamedJob(jobName, MantisJobState.MetaState.Active).toBlocking().first();
        System.out.println("json: " + json);
    }
}

