/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.client.examples;

import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import io.mantisrx.client.MantisSSEJob;
import io.mantisrx.client.examples.SubmitEphemeralJob;
import io.mantisrx.common.MantisServerSentEvent;
import io.mantisrx.runtime.JobSla;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscription;
import rx.functions.Action1;

public class SubmitWithUniqueTag {
    private static final Logger logger = LoggerFactory.getLogger(SubmitWithUniqueTag.class);
    @Argument(alias="p", description="Specify a configuration file", required=true)
    private static String propFile = "";
    @Argument(alias="n", description="Job name for submission", required=false)
    private static String jobName;

    public static void main(String[] args) {
        try {
            Args.parse(SubmitWithUniqueTag.class, (String[])args);
        }
        catch (IllegalArgumentException e) {
            Args.usage(SubmitEphemeralJob.class);
            System.exit(1);
        }
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(propFile);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JobSla jobSla = new JobSla.Builder().withUniqueJobTagValue("foobar").build();
        MantisSSEJob job = new MantisSSEJob.Builder(properties).jobSla(jobSla).name(jobName).buildJobSubmitter();
        Observable<Observable<MantisServerSentEvent>> o = job.submitAndGet();
        final CountDownLatch latch = new CountDownLatch(5);
        Subscription subscribe = o.doOnNext((Action1)new Action1<Observable<MantisServerSentEvent>>(){

            public void call(Observable<MantisServerSentEvent> eventObservable) {
                eventObservable.doOnNext((Action1)new Action1<MantisServerSentEvent>(){

                    public void call(MantisServerSentEvent event) {
                        System.out.println("event: " + event.getEventAsString());
                        latch.countDown();
                    }
                }).subscribe();
            }
        }).subscribe();
        try {
            if (latch.await(50L, TimeUnit.SECONDS)) {
                System.out.println("SUCCESS");
            } else {
                System.out.println("FAILURE");
            }
            subscribe.unsubscribe();
            System.exit(0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

