/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.client.examples;

import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import io.mantisrx.client.MantisSSEJob;
import io.mantisrx.client.SinkConnectionsStatus;
import io.mantisrx.client.examples.SubmitEphemeralJob;
import io.mantisrx.common.MantisServerSentEvent;
import io.mantisrx.server.core.Configurations;
import io.mantisrx.server.core.CoreConfiguration;
import io.mantisrx.server.core.JobSchedulingInfo;
import io.mantisrx.server.core.WorkerAssignments;
import io.mantisrx.server.core.WorkerHost;
import io.mantisrx.server.master.client.HighAvailabilityServices;
import io.mantisrx.server.master.client.HighAvailabilityServicesUtil;
import io.mantisrx.server.master.client.MantisMasterGateway;
import io.mantisrx.server.master.client.MasterClientWrapper;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;

public class ConnectToNamedJob {
    private static final Logger logger = LoggerFactory.getLogger(ConnectToNamedJob.class);
    private static final AtomicLong prevDroppedCount = new AtomicLong(0L);
    @Argument(alias="p", description="Specify a configuration file", required=true)
    private static String propFile = "";
    @Argument(alias="n", description="Job name for submission", required=true)
    private static String jobName;

    public static void main2(String[] args) {
        List remArgs = Collections.emptyList();
        try {
            remArgs = Args.parse(ConnectToNamedJob.class, (String[])args);
        }
        catch (IllegalArgumentException e) {
            Args.usage(SubmitEphemeralJob.class);
            System.exit(1);
        }
        if (remArgs.isEmpty()) {
            System.err.println("Must provide JobId as argument");
            System.exit(1);
        }
        final String jobId = (String)remArgs.get(0);
        Properties properties = new Properties();
        System.out.println("propfile=" + propFile);
        try (FileInputStream inputStream = new FileInputStream(propFile);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HighAvailabilityServices haServices = HighAvailabilityServicesUtil.createHAServices((CoreConfiguration)((CoreConfiguration)Configurations.frmProperties((Properties)properties, CoreConfiguration.class)));
        MasterClientWrapper clientWrapper = new MasterClientWrapper(haServices.getMasterClientApi());
        clientWrapper.getMasterClientApi().doOnNext((Action1)new Action1<MantisMasterGateway>(){

            public void call(MantisMasterGateway clientApi) {
                logger.info("************** connecting to schedInfo for job " + jobId);
                clientApi.schedulingChanges(jobId).doOnNext((Action1)new Action1<JobSchedulingInfo>(){

                    public void call(JobSchedulingInfo schedulingInfo) {
                        WorkerAssignments workerAssignments = (WorkerAssignments)schedulingInfo.getWorkerAssignments().get(1);
                        for (Map.Entry entry : workerAssignments.getHosts().entrySet()) {
                            System.out.println("Worker " + entry.getKey() + ": state=" + ((WorkerHost)entry.getValue()).getState() + ", host=" + ((WorkerHost)entry.getValue()).getHost() + ", port=" + ((WorkerHost)entry.getValue()).getPort());
                        }
                    }
                }).subscribe();
            }
        }).subscribe();
        try {
            Thread.sleep(10000000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        AtomicLong eventCounter = new AtomicLong(0L);
        System.setProperty("log4j.logger.io", "DEBUG");
        try {
            Args.parse(ConnectToNamedJob.class, (String[])args);
        }
        catch (IllegalArgumentException e) {
            Args.usage(SubmitEphemeralJob.class);
            System.exit(1);
        }
        Properties properties = new Properties();
        System.out.println("propfile=" + propFile);
        try (FileInputStream inputStream = new FileInputStream(propFile);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        final CountDownLatch latch = new CountDownLatch(1);
        MantisSSEJob job = null;
        try {
            job = new MantisSSEJob.Builder(properties).name(jobName).onConnectionReset(new Action1<Throwable>(){

                public void call(Throwable throwable) {
                    System.err.println("Reconnecting due to error: " + throwable.getMessage());
                }
            }).sinkConnectionsStatusObserver(new Observer<SinkConnectionsStatus>(){

                public void onCompleted() {
                    System.out.println("ConnectionStatusObserver completed");
                }

                public void onError(Throwable e) {
                    System.err.println("ConnectionStatusObserver error: " + e.getMessage());
                }

                public void onNext(SinkConnectionsStatus status) {
                    System.out.println("ConnectionStatusObserver: receiving from " + status.getRecevingDataFrom() + ", connected to " + status.getNumConnected() + " of " + status.getTotal());
                }
            }).sinkDataRecvTimeoutSecs(11L).buildJobConnector();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Subscribing now");
        Subscription subscription = job.connectAndGet().doOnNext((Action1)new Action1<Observable<MantisServerSentEvent>>(){

            public void call(Observable<MantisServerSentEvent> o) {
                o.doOnNext((Action1)new Action1<MantisServerSentEvent>(){

                    public void call(MantisServerSentEvent data) {
                        logger.info("Got event:  + " + data);
                        latch.countDown();
                    }
                }).subscribe();
            }
        }).doOnError((Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                logger.error(throwable.getMessage());
            }
        }).doOnCompleted(new Action0(){

            public void call() {
                System.out.println("Completed");
                System.exit(0);
            }
        }).subscribe();
        try {
            boolean await = latch.await(30L, TimeUnit.SECONDS);
            if (await) {
                System.out.println("PASSED");
            } else {
                System.err.println("FAILED!");
            }
            Thread.sleep(5000000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        subscription.unsubscribe();
        System.out.println("Unsubscribed");
        try {
            Thread.sleep(80000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(0);
    }
}

