/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.client.examples;

import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import io.mantisrx.client.MantisSSEJob;
import io.mantisrx.common.MantisServerSentEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;

public class SubmitEphemeralJob {
    private static final Logger logger = LoggerFactory.getLogger(SubmitEphemeralJob.class);
    @Argument(alias="p", description="Specify a configuration file", required=true)
    private static String propFile = "";
    @Argument(alias="n", description="Job name for submission", required=false)
    private static String jobName;

    public static void main(String[] args) {
        try {
            Args.parse(SubmitEphemeralJob.class, (String[])args);
        }
        catch (IllegalArgumentException e) {
            Args.usage(SubmitEphemeralJob.class);
            System.exit(1);
        }
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(propFile);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        final CountDownLatch latch = new CountDownLatch(1);
        Subscription subscription1 = null;
        MantisSSEJob job1 = new MantisSSEJob.Builder(properties).name(jobName).onCloseKillJob().onConnectionReset(new Action1<Throwable>(){

            public void call(Throwable throwable) {
                System.err.println("Reconnecting due to error: " + throwable.getMessage());
            }
        }).buildJobSubmitter();
        try {
            Observable<Observable<MantisServerSentEvent>> observable = job1.submitAndGet();
            subscription1 = observable.doOnNext((Action1)new Action1<Observable<MantisServerSentEvent>>(){

                public void call(Observable<MantisServerSentEvent> o) {
                    o.doOnNext((Action1)new Action1<MantisServerSentEvent>(){

                        public void call(MantisServerSentEvent data) {
                            logger.info("Got event: " + data);
                            latch.countDown();
                        }
                    }).subscribe();
                }
            }).doOnCompleted(new Action0(){

                public void call() {
                    System.out.println("Observable completed!!!");
                }
            }).subscribe();
            if (latch.await(50L, TimeUnit.SECONDS)) {
                System.out.println("SUCCESS");
            } else {
                System.out.println("FAILURE");
            }
            if (latch.await(50L, TimeUnit.SECONDS)) {
                System.out.println("SUCCESS");
            } else {
                System.out.println("FAILURE");
            }
            Thread.sleep(30000000L);
            subscription1.unsubscribe();
            job1.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

