/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api.push;

import io.mantisrx.runtime.parameter.SinkParameter;
import io.mantisrx.runtime.parameter.SinkParameters;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.vavr.CheckedFunction0;
import io.vavr.collection.List;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.stream.Collectors;

public final class PushConnectionDetails {
    private final String uri;
    public final String target;
    public final TARGET_TYPE type;
    public final List<String> regions;

    public static TARGET_TYPE determineTargetType(String uri) {
        if (uri.startsWith("/jobconnectbyname") || uri.startsWith("/api/v1/jobconnectbyname")) {
            return TARGET_TYPE.CONNECT_BY_NAME;
        }
        if (uri.startsWith("/jobconnectbyid") || uri.startsWith("/api/v1/jobconnectbyid")) {
            return TARGET_TYPE.CONNECT_BY_ID;
        }
        if (uri.startsWith("/jobstatus/") || uri.startsWith("/api/v1/jobstatus/")) {
            return TARGET_TYPE.JOB_STATUS;
        }
        if (uri.startsWith("/api/v1/jobs/schedulingInfo/")) {
            return TARGET_TYPE.JOB_SCHEDULING_INFO;
        }
        if (uri.startsWith("/jobClusters/discoveryInfoStream/")) {
            return TARGET_TYPE.JOB_CLUSTER_DISCOVERY;
        }
        if (uri.startsWith("/api/v1/metrics/")) {
            return TARGET_TYPE.METRICS;
        }
        throw new IllegalArgumentException("Unable to determine push connection type from URI: " + uri);
    }

    public static String determineTarget(String uri) {
        String sanitized = uri.replaceFirst("^/(api/v1/)?(jobconnectbyid|jobconnectbyname|jobstatus|jobs/schedulingInfo|jobClusters/discoveryInfoStream|metrics)/", "");
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(sanitized);
        return queryStringDecoder.path();
    }

    public SinkParameters getSinkparameters() {
        SinkParameters.Builder builder = new SinkParameters.Builder();
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.uri);
        builder.parameters(queryStringDecoder.parameters().entrySet().stream().flatMap(entry -> ((java.util.List)entry.getValue()).stream().map(val -> Try.of((CheckedFunction0 & Serializable)() -> new SinkParameter((String)entry.getKey(), val))).filter(Try::isSuccess).map(Try::get)).collect(Collectors.toList()).toArray(new SinkParameter[0]));
        return builder.build();
    }

    public static PushConnectionDetails from(String uri) {
        return PushConnectionDetails.from(uri, (List<String>)List.empty());
    }

    public static PushConnectionDetails from(String uri, List<String> regions) {
        return new PushConnectionDetails(uri, PushConnectionDetails.determineTarget(uri), PushConnectionDetails.determineTargetType(uri), regions);
    }

    public static PushConnectionDetails from(String uri, java.util.List<String> regions) {
        return new PushConnectionDetails(uri, PushConnectionDetails.determineTarget(uri), PushConnectionDetails.determineTargetType(uri), (List<String>)List.ofAll(regions));
    }

    public PushConnectionDetails(String uri, String target, TARGET_TYPE type, List<String> regions) {
        this.uri = uri;
        this.target = target;
        this.type = type;
        this.regions = regions;
    }

    public String getUri() {
        return this.uri;
    }

    public String getTarget() {
        return this.target;
    }

    public TARGET_TYPE getType() {
        return this.type;
    }

    public List<String> getRegions() {
        return this.regions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PushConnectionDetails)) {
            return false;
        }
        PushConnectionDetails other = (PushConnectionDetails)o;
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        TARGET_TYPE this$type = this.getType();
        TARGET_TYPE other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<String> this$regions = this.getRegions();
        List<String> other$regions = other.getRegions();
        return !(this$regions == null ? other$regions != null : !this$regions.equals(other$regions));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        TARGET_TYPE $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<String> $regions = this.getRegions();
        result = result * 59 + ($regions == null ? 43 : $regions.hashCode());
        return result;
    }

    public String toString() {
        return "PushConnectionDetails(uri=" + this.getUri() + ", target=" + this.getTarget() + ", type=" + (Object)((Object)this.getType()) + ", regions=" + this.getRegions() + ")";
    }

    public static enum TARGET_TYPE {
        CONNECT_BY_NAME,
        CONNECT_BY_ID,
        JOB_STATUS,
        JOB_SCHEDULING_INFO,
        JOB_CLUSTER_DISCOVERY,
        METRICS;

    }
}

