/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api.filters;

import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.filters.http.HttpInboundSyncFilter;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.netty.filter.ZuulEndPointRunner;
import io.mantisrx.api.filters.AppStreamDiscovery;
import io.mantisrx.api.filters.Artifacts;
import io.mantisrx.api.filters.Favicon;
import io.mantisrx.api.filters.Healthcheck;
import io.mantisrx.api.filters.MQLParser;
import io.mantisrx.api.filters.MREAppStreamToJobClusterMapping;
import io.mantisrx.api.filters.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Routes
extends HttpInboundSyncFilter {
    private static final Logger log = LoggerFactory.getLogger(Routes.class);

    public int filterOrder() {
        return 0;
    }

    public boolean shouldFilter(HttpRequestMessage httpRequestMessage) {
        return true;
    }

    public HttpRequestMessage apply(HttpRequestMessage request) {
        SessionContext context = request.getContext();
        String path = request.getPath();
        String host = request.getOriginalHost();
        if (request.getMethod().toLowerCase().equals("options")) {
            context.setEndpoint(Options.class.getCanonicalName());
        } else if (path.equalsIgnoreCase("/healthcheck")) {
            context.setEndpoint(Healthcheck.class.getCanonicalName());
        } else if (path.equalsIgnoreCase("/favicon.ico")) {
            context.setEndpoint(Favicon.class.getCanonicalName());
        } else if (path.startsWith("/api/v1/artifacts")) {
            context.setEndpoint(Artifacts.class.getCanonicalName());
        } else if (path.equalsIgnoreCase("/api/v1/mantis/publish/streamDiscovery")) {
            context.setEndpoint(AppStreamDiscovery.class.getCanonicalName());
        } else if (path.startsWith("/jobClusters/discoveryInfo")) {
            String jobCluster = request.getPath().replaceFirst("/jobClusters/discoveryInfo/", "");
            String newUrl = "/api/v1/jobClusters/" + jobCluster + "/latestJobDiscoveryInfo";
            request.setPath(newUrl);
            context.setEndpoint(ZuulEndPointRunner.PROXY_ENDPOINT_FILTER_NAME);
            context.setRouteVIP("api");
        } else if (path.equalsIgnoreCase("/api/v1/mql/parse")) {
            context.setEndpoint(MQLParser.class.getCanonicalName());
        } else if (path.equals("/api/v1/mantis/publish/streamJobClusterMap")) {
            context.setEndpoint(MREAppStreamToJobClusterMapping.class.getCanonicalName());
        } else {
            context.setEndpoint(ZuulEndPointRunner.PROXY_ENDPOINT_FILTER_NAME);
            context.setRouteVIP("api");
        }
        return request;
    }
}

