/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api.services;

import com.netflix.spectator.api.Counter;
import com.netflix.zuul.netty.SpectatorUtils;
import io.mantisrx.api.services.AppStreamStore;
import io.mantisrx.common.JsonSerializer;
import io.mantisrx.discovery.proto.AppJobClustersMap;
import io.mantisrx.shaded.org.apache.curator.framework.listen.Listenable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationBasedAppStreamStore
implements AppStreamStore {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationBasedAppStreamStore.class);
    private final JsonSerializer jsonSerializer;
    private final AtomicReference<AppJobClustersMap> appJobClusterMappings = new AtomicReference();
    private final Counter appJobClusterMappingNullCount;
    private final Counter appJobClusterMappingFailCount;
    private final Counter appJobClusterMappingRequestCount;

    public ConfigurationBasedAppStreamStore(ConfigSource configSource) {
        configSource.getListenable().addListener(newConfig -> this.updateAppJobClustersMapping(newConfig));
        this.jsonSerializer = new JsonSerializer();
        this.updateAppJobClustersMapping((String)configSource.get());
        this.appJobClusterMappingNullCount = SpectatorUtils.newCounter((String)"appJobClusterMappingNull", (String)"mantisapi");
        this.appJobClusterMappingRequestCount = SpectatorUtils.newCounter((String)"appJobClusterMappingRequest", (String)"mantisapi", (String[])new String[]{"app", "unknown"});
        this.appJobClusterMappingFailCount = SpectatorUtils.newCounter((String)"appJobClusterMappingFail", (String)"mantisapi");
    }

    @Override
    public AppJobClustersMap getJobClusterMappings(Collection<String> apps) throws IOException {
        return this.getAppJobClustersMap(apps, this.appJobClusterMappings.get());
    }

    private AppJobClustersMap getAppJobClustersMap(Collection<String> appNames, @Nullable AppJobClustersMap appJobClustersMap) throws IOException {
        if (appJobClustersMap != null) {
            AppJobClustersMap appJobClusters;
            if (appNames.size() > 0) {
                appJobClusters = appJobClustersMap.getFilteredAppJobClustersMap(new ArrayList<String>(appNames));
            } else {
                this.appJobClusterMappingRequestCount.increment();
                appJobClusters = appJobClustersMap;
            }
            return appJobClusters;
        }
        this.appJobClusterMappingNullCount.increment();
        throw new IOException("AppJobClustersMap is null");
    }

    private void updateAppJobClustersMapping(String appJobClusterStr) {
        try {
            AppJobClustersMap appJobClustersMap = (AppJobClustersMap)this.jsonSerializer.fromJSON(appJobClusterStr, AppJobClustersMap.class);
            log.info("appJobClustersMap updated to {}", (Object)appJobClustersMap);
            this.appJobClusterMappings.set(appJobClustersMap);
        }
        catch (Exception ioe) {
            log.error("failed to update appJobClustersMap on Property update {}", (Object)appJobClusterStr, (Object)ioe);
            this.appJobClusterMappingFailCount.increment();
        }
    }

    public static interface ConfigurationChangeListener {
        public void onConfigChange(String var1);
    }

    public static interface ConfigSource
    extends Supplier<String> {
        public Listenable<ConfigurationChangeListener> getListenable();
    }
}

