/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api.filters;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Timer;
import com.netflix.zuul.filters.http.HttpOutboundSyncFilter;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.netty.SpectatorUtils;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class MetricsReporting
extends HttpOutboundSyncFilter {
    private static final ConcurrentHashMap<Tuple2<String, String>, Timer> timerCache = new ConcurrentHashMap(500);
    private static final ConcurrentHashMap<Tuple2<String, String>, Counter> counterCache = new ConcurrentHashMap(500);

    public HttpResponseMessage apply(HttpResponseMessage input) {
        String path = input.getInboundRequest().getPath();
        String status = this.statusCodeToStringRepresentation(input.getStatus());
        timerCache.computeIfAbsent((Tuple2<String, String>)Tuple.of((Object)path, (Object)status), tuple -> SpectatorUtils.newTimer((String)"latency", (String)path, (String[])new String[]{"status", status})).record((long)input.getContext().getOriginReportedDuration(), TimeUnit.NANOSECONDS);
        counterCache.computeIfAbsent((Tuple2<String, String>)Tuple.of((Object)path, (Object)status), tuple -> SpectatorUtils.newCounter((String)"requests", (String)path, (String[])new String[]{"status", status})).increment();
        return input;
    }

    private String statusCodeToStringRepresentation(Integer statusCode) {
        return statusCode / 100 + "xx";
    }

    public int filterOrder() {
        return -100;
    }

    public boolean shouldFilter(HttpResponseMessage msg) {
        return true;
    }
}

