/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api.filters;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.inject.Inject;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.patterns.PolledMeter;
import com.netflix.zuul.filters.http.HttpOutboundSyncFilter;
import com.netflix.zuul.message.http.HttpResponseMessage;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterCacheLoader
extends HttpOutboundSyncFilter {
    private static final Logger log = LoggerFactory.getLogger(MasterCacheLoader.class);
    private static DynamicBooleanProperty cacheEnabled = new DynamicBooleanProperty("mantisapi.cache.enabled", false);
    private static DynamicIntProperty cacheSize = new DynamicIntProperty("mantisapi.cache.size", 1000);
    private static DynamicIntProperty cacheDurationSeconds = new DynamicIntProperty("mantisapi.cache.seconds", 1);
    public static final Cache<String, String> masterCache = CacheBuilder.newBuilder().maximumSize((long)cacheSize.get()).expireAfterWrite((long)cacheDurationSeconds.get(), TimeUnit.SECONDS).build();

    public boolean needsBodyBuffered(HttpResponseMessage message) {
        return true;
    }

    @Inject
    public MasterCacheLoader(Registry registry) {
        CacheStats stats = masterCache.stats();
        ((PolledMeter.Builder)((PolledMeter.Builder)PolledMeter.using((Registry)registry).withName("mantis.api.cache.size")).withTag((Tag)new BasicTag("id", "api"))).monitorMonotonicCounter(masterCache, Cache::size);
        ((PolledMeter.Builder)((PolledMeter.Builder)PolledMeter.using((Registry)registry).withName("mantis.api.cache.hitCount")).withTag((Tag)new BasicTag("id", "api"))).monitorMonotonicCounter((Object)stats, CacheStats::hitCount);
        ((PolledMeter.Builder)((PolledMeter.Builder)PolledMeter.using((Registry)registry).withName("mantis.api.cache.missCount")).withTag((Tag)new BasicTag("id", "api"))).monitorMonotonicCounter((Object)stats, CacheStats::missCount);
    }

    public HttpResponseMessage apply(HttpResponseMessage input) {
        String key = input.getInboundRequest().getPathAndQuery();
        String responseBody = input.getBodyAsText();
        if (null != responseBody && cacheEnabled.get()) {
            masterCache.put((Object)key, (Object)responseBody);
        }
        return input;
    }

    public int filterOrder() {
        return 999;
    }

    public boolean shouldFilter(HttpResponseMessage msg) {
        return msg.getOutboundRequest().getContext().getRouteVIP() != null && msg.getOutboundRequest().getContext().getRouteVIP().equalsIgnoreCase("api") && msg.getInboundRequest().getMethod().equalsIgnoreCase("get") && msg.getHeaders().getAll("x-nflx-mantisapi-cached").size() == 0;
    }
}

