/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api.filters;

import com.netflix.zuul.filters.http.HttpSyncEndpoint;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.message.http.HttpResponseMessageImpl;
import io.mantisrx.mql.shaded.clojure.java.api.Clojure;
import io.mantisrx.mql.shaded.clojure.lang.IFn;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQLParser
extends HttpSyncEndpoint {
    private static final Logger log = LoggerFactory.getLogger(MQLParser.class);
    private static IFn require = Clojure.var((Object)"io.mantisrx.mql.shaded.clojure.core", (Object)"require");
    private static IFn parses;
    private static IFn getParseError;
    private static final ObjectMapper objectMapper;

    public HttpResponseMessage apply(HttpRequestMessage input) {
        String query = input.getQueryParams().getFirst("criterion");
        boolean parses = MQLParser.parses(query);
        String parseError = MQLParser.getParseError(query);
        MQLParseResult result = new MQLParseResult(parses, query, parses ? "" : parseError);
        try {
            HttpResponseMessageImpl response = new HttpResponseMessageImpl(input.getContext(), input, 200);
            response.setBody(objectMapper.writeValueAsBytes((Object)result));
            return response;
        }
        catch (JsonProcessingException ex) {
            HttpResponseMessageImpl response = new HttpResponseMessageImpl(input.getContext(), input, 500);
            response.setBody(this.getErrorResponse(ex.getMessage()).getBytes(Charset.defaultCharset()));
            return response;
        }
    }

    public static Boolean parses(String query) {
        return (Boolean)parses.invoke((Object)query);
    }

    public static String getParseError(String query) {
        return (String)getParseError.invoke((Object)query);
    }

    private String getErrorResponse(String exceptionMessage) {
        StringBuilder sb = new StringBuilder(50);
        sb.append("{\"success\": false, \"messages\": \"");
        sb.append(exceptionMessage);
        sb.append("\"}");
        return sb.toString();
    }

    static {
        require.invoke(Clojure.read((String)"io.mantisrx.mql.core"));
        require.invoke(Clojure.read((String)"io.mantisrx.mql.jvm.interfaces.server"));
        require.invoke(Clojure.read((String)"io.mantisrx.mql.jvm.interfaces.core"));
        parses = Clojure.var((Object)"io.mantisrx.mql.jvm.interfaces.core", (Object)"parses?");
        getParseError = Clojure.var((Object)"io.mantisrx.mql.jvm.interfaces.core", (Object)"get-parse-error");
        objectMapper = new ObjectMapper();
    }

    public final class MQLParseResult {
        private final boolean success;
        private final String criterion;
        private final String message;

        public MQLParseResult(boolean success, String criterion, String message) {
            this.success = success;
            this.criterion = criterion;
            this.message = message;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getCriterion() {
            return this.criterion;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MQLParseResult)) {
                return false;
            }
            MQLParseResult other = (MQLParseResult)o;
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            String this$criterion = this.getCriterion();
            String other$criterion = other.getCriterion();
            if (this$criterion == null ? other$criterion != null : !this$criterion.equals(other$criterion)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            String $criterion = this.getCriterion();
            result = result * 59 + ($criterion == null ? 43 : $criterion.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public String toString() {
            return "MQLParser.MQLParseResult(success=" + this.isSuccess() + ", criterion=" + this.getCriterion() + ", message=" + this.getMessage() + ")";
        }
    }
}

