/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api.services.artifacts;

import io.mantisrx.api.proto.Artifact;
import io.mantisrx.api.services.artifacts.ArtifactManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class InMemoryArtifactManager
implements ArtifactManager {
    private Map<String, Artifact> artifacts = new HashMap<String, Artifact>();

    @Override
    public List<String> getArtifacts() {
        return this.artifacts.values().stream().map(Artifact::getFileName).collect(Collectors.toList());
    }

    @Override
    public Optional<Artifact> getArtifact(String name) {
        return this.artifacts.values().stream().filter(artifact -> artifact.getFileName().equals(name)).findFirst();
    }

    @Override
    public void deleteArtifact(String name) {
        this.artifacts.remove(name);
    }

    @Override
    public void putArtifact(Artifact artifact) {
        this.artifacts.put(artifact.getFileName(), artifact);
    }
}

