/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api.filters;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.zuul.filters.http.HttpOutboundSyncFilter;
import com.netflix.zuul.message.http.HttpResponseMessage;
import io.mantisrx.api.services.JobDiscoveryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobDiscoveryCacheLoader
extends HttpOutboundSyncFilter {
    private static final Logger log = LoggerFactory.getLogger(JobDiscoveryCacheLoader.class);
    private static DynamicBooleanProperty cacheEnabled = new DynamicBooleanProperty("mantisapi.cache.enabled", false);

    public boolean needsBodyBuffered(HttpResponseMessage message) {
        return true;
    }

    public int filterOrder() {
        return 999;
    }

    public boolean shouldFilter(HttpResponseMessage response) {
        return response.getOutboundRequest().getPath().matches("^/api/v1/jobClusters/.*/latestJobDiscoveryInfo$") && response.getHeaders().getAll("x-nflx-mantisapi-cached").isEmpty() && cacheEnabled.get();
    }

    public HttpResponseMessage apply(HttpResponseMessage response) {
        String jobCluster = response.getOutboundRequest().getPath().replaceFirst("^/api/v1/jobClusters/", "").replaceFirst("/latestJobDiscoveryInfo$", "");
        String responseBody = response.getBodyAsText();
        if (null != responseBody) {
            log.info("Caching latest job discovery info for {}.", (Object)jobCluster);
            JobDiscoveryService.jobDiscoveryInfoCache.put((Object)jobCluster, (Object)response.getBodyAsText());
        }
        return response;
    }
}

