/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api.filters;

import com.google.common.base.Strings;
import com.netflix.zuul.filters.http.HttpSyncEndpoint;
import com.netflix.zuul.message.http.HttpHeaderNames;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.message.http.HttpResponseMessageImpl;
import io.mantisrx.api.proto.Artifact;
import io.mantisrx.api.services.artifacts.ArtifactManager;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Artifacts
extends HttpSyncEndpoint {
    private static final Logger log = LoggerFactory.getLogger(Artifacts.class);
    private final ArtifactManager artifactManager;
    private final ObjectMapper objectMapper;
    public static final String PATH_SPEC = "/api/v1/artifacts";

    public boolean needsBodyBuffered(HttpRequestMessage input) {
        return input.getMethod().toLowerCase().equals("post");
    }

    @Inject
    public Artifacts(ArtifactManager artifactManager, ObjectMapper objectMapper) {
        this.artifactManager = artifactManager;
        this.objectMapper = objectMapper;
        artifactManager.putArtifact(new Artifact("mantis.json", 0L, new byte[0]));
        artifactManager.putArtifact(new Artifact("mantis.zip", 0L, new byte[0]));
    }

    public HttpResponseMessage apply(HttpRequestMessage request) {
        if (request.getMethod().toLowerCase().equals("get")) {
            String fileName = request.getPath().replaceFirst("^/api/v1/artifacts/?", "");
            if (Strings.isNullOrEmpty((String)fileName)) {
                List<String> files = this.artifactManager.getArtifacts();
                Try serialized = Try.of((CheckedFunction0 & Serializable)() -> this.objectMapper.writeValueAsString((Object)files));
                return (HttpResponseMessage)serialized.map(body -> {
                    HttpResponseMessageImpl response = new HttpResponseMessageImpl(request.getContext(), request, 200);
                    response.getHeaders().set(HttpHeaderNames.CONTENT_TYPE.toString(), HttpHeaderValues.APPLICATION_JSON.toString());
                    response.setBodyAsText(body);
                    return response;
                }).getOrElseGet(t -> {
                    HttpResponseMessageImpl response = new HttpResponseMessageImpl(request.getContext(), request, 500);
                    response.getHeaders().set(HttpHeaderNames.CONTENT_TYPE.toString(), HttpHeaderValues.TEXT_PLAIN.toString());
                    response.setBodyAsText(t.getMessage());
                    return response;
                });
            }
            Optional<Artifact> artifact = this.artifactManager.getArtifact(fileName);
            return artifact.map(art -> {
                HttpResponseMessageImpl response = new HttpResponseMessageImpl(request.getContext(), request, HttpResponseStatus.OK.code());
                response.setBody(art.getContent());
                response.getHeaders().set(HttpHeaderNames.CONTENT_TYPE, fileName.endsWith("json") ? HttpHeaderValues.APPLICATION_JSON.toString() : HttpHeaderValues.APPLICATION_OCTET_STREAM.toString());
                response.getHeaders().set("Content-Disposition", String.format("attachment; filename=\"%s\"", fileName));
                return response;
            }).orElseGet(() -> {
                HttpResponseMessageImpl response = new HttpResponseMessageImpl(request.getContext(), request, HttpResponseStatus.NOT_FOUND.code());
                response.setBody(new byte[0]);
                return response;
            });
        }
        if (request.getMethod().toLowerCase().equals("post")) {
            byte[] body2 = request.getBody();
            this.artifactManager.putArtifact(new Artifact("testing.json", body2.length, body2));
            HttpResponseMessageImpl response = new HttpResponseMessageImpl(request.getContext(), request, HttpResponseStatus.OK.code());
            return response;
        }
        HttpResponseMessageImpl response = new HttpResponseMessageImpl(request.getContext(), request, HttpResponseStatus.METHOD_NOT_ALLOWED.code());
        response.setBodyAsText(HttpResponseStatus.METHOD_NOT_ALLOWED.reasonPhrase());
        response.getHeaders().set(HttpHeaderNames.CONTENT_TYPE.toString(), HttpHeaderValues.TEXT_PLAIN.toString());
        return response;
    }
}

