/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api.filters;

import com.google.inject.Inject;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.filters.http.HttpSyncEndpoint;
import com.netflix.zuul.message.http.HttpHeaderNames;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.message.http.HttpResponseMessageImpl;
import com.netflix.zuul.stats.status.StatusCategory;
import com.netflix.zuul.stats.status.StatusCategoryUtils;
import com.netflix.zuul.stats.status.ZuulStatusCategory;
import io.mantisrx.api.proto.AppDiscoveryMap;
import io.mantisrx.api.services.AppStreamDiscoveryService;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.vavr.CheckedFunction0;
import io.vavr.control.Either;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppStreamDiscovery
extends HttpSyncEndpoint {
    private static final Logger log = LoggerFactory.getLogger(AppStreamDiscovery.class);
    private final AppStreamDiscoveryService appStreamDiscoveryService;
    private final ObjectMapper objectMapper;
    private static final String APPNAME_QUERY_PARAM = "app";

    @Inject
    public AppStreamDiscovery(AppStreamDiscoveryService appStreamDiscoveryService, ObjectMapper objectMapper) {
        this.appStreamDiscoveryService = appStreamDiscoveryService;
        this.objectMapper = objectMapper;
    }

    public HttpResponseMessage apply(HttpRequestMessage request) {
        List apps = request.getQueryParams().get(APPNAME_QUERY_PARAM);
        Either<String, AppDiscoveryMap> result = this.appStreamDiscoveryService.getAppDiscoveryMap(apps);
        return (HttpResponseMessage)result.bimap(errorMessage -> {
            HttpResponseMessageImpl resp = new HttpResponseMessageImpl(request.getContext(), request, 500);
            resp.setBodyAsText(errorMessage);
            StatusCategoryUtils.setStatusCategory((SessionContext)request.getContext(), (StatusCategory)ZuulStatusCategory.FAILURE_LOCAL);
            return resp;
        }, appDiscoveryMap -> {
            Try serialized = Try.of((CheckedFunction0 & Serializable)() -> this.objectMapper.writeValueAsString(appDiscoveryMap));
            if (serialized.isSuccess()) {
                StatusCategoryUtils.setStatusCategory((SessionContext)request.getContext(), (StatusCategory)ZuulStatusCategory.SUCCESS);
                HttpResponseMessageImpl resp = new HttpResponseMessageImpl(request.getContext(), request, 200);
                resp.getHeaders().set(HttpHeaderNames.CONTENT_TYPE.toString(), HttpHeaderValues.APPLICATION_JSON.toString());
                resp.setBodyAsText((String)serialized.get());
                return resp;
            }
            StatusCategoryUtils.setStatusCategory((SessionContext)request.getContext(), (StatusCategory)ZuulStatusCategory.FAILURE_LOCAL);
            HttpResponseMessageImpl resp = new HttpResponseMessageImpl(request.getContext(), request, 500);
            resp.getHeaders().set(HttpHeaderNames.CONTENT_TYPE.toString(), HttpHeaderValues.TEXT_PLAIN.toString());
            resp.setBodyAsText((String)serialized.getOrElseGet(Throwable::getMessage));
            return resp;
        }).getOrElseGet(Function.identity());
    }
}

