/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api.filters;

import com.google.common.base.Strings;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.zuul.filters.http.HttpInboundSyncFilter;
import com.netflix.zuul.message.http.HttpHeaderNames;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.message.http.HttpResponseMessageImpl;
import io.mantisrx.api.services.JobDiscoveryService;
import io.netty.handler.codec.http.HttpHeaderValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobDiscoveryInfoCacheHitChecker
extends HttpInboundSyncFilter {
    private static final Logger log = LoggerFactory.getLogger(JobDiscoveryInfoCacheHitChecker.class);
    public static final String PATH_SPEC = "/jobClusters/discoveryInfo";
    private static DynamicBooleanProperty cacheEnabled = new DynamicBooleanProperty("mantisapi.cache.enabled", false);

    public int filterOrder() {
        return -1;
    }

    public boolean shouldFilter(HttpRequestMessage httpRequestMessage) {
        String jobCluster = httpRequestMessage.getPath().replaceFirst("/jobClusters/discoveryInfo/", "");
        return httpRequestMessage.getPath().startsWith(PATH_SPEC) && JobDiscoveryService.jobDiscoveryInfoCache.getIfPresent((Object)jobCluster) != null;
    }

    public HttpRequestMessage apply(HttpRequestMessage request) {
        String jobCluster = request.getPath().replaceFirst("/jobClusters/discoveryInfo/", "");
        HttpResponseMessageImpl resp = new HttpResponseMessageImpl(request.getContext(), request, 200);
        String bodyText = (String)JobDiscoveryService.jobDiscoveryInfoCache.getIfPresent((Object)jobCluster);
        if (cacheEnabled.get() && !Strings.isNullOrEmpty((String)bodyText)) {
            log.info("Serving cached job discovery info for {}.", (Object)jobCluster);
            resp.setBodyAsText(bodyText);
            resp.getHeaders().set(HttpHeaderNames.CONTENT_TYPE.toString(), HttpHeaderValues.APPLICATION_JSON.toString());
            resp.getHeaders().set("x-nflx-mantisapi-cached", "true");
            request.getContext().setStaticResponse((HttpResponseMessage)resp);
        }
        return request;
    }
}

