/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.netflix.config.ConfigurationManager;
import com.netflix.discovery.guice.EurekaModule;
import com.netflix.netty.common.accesslog.AccessLogPublisher;
import com.netflix.netty.common.status.ServerStatusManager;
import com.netflix.spectator.api.DefaultRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.patterns.ThreadPoolMonitor;
import com.netflix.zuul.BasicRequestCompleteHandler;
import com.netflix.zuul.DynamicCodeCompiler;
import com.netflix.zuul.DynamicFilterLoader;
import com.netflix.zuul.FilterFileManager;
import com.netflix.zuul.FilterLoader;
import com.netflix.zuul.RequestCompleteHandler;
import com.netflix.zuul.context.SessionContextDecorator;
import com.netflix.zuul.context.ZuulSessionContextDecorator;
import com.netflix.zuul.filters.FilterRegistry;
import com.netflix.zuul.filters.MutableFilterRegistry;
import com.netflix.zuul.groovy.GroovyCompiler;
import com.netflix.zuul.groovy.GroovyFileFilter;
import com.netflix.zuul.init.ZuulFiltersModule;
import com.netflix.zuul.netty.server.BaseServerStartup;
import com.netflix.zuul.netty.server.ClientRequestReceiver;
import com.netflix.zuul.origins.BasicNettyOriginManager;
import com.netflix.zuul.origins.OriginManager;
import com.netflix.zuul.stats.BasicRequestMetricsPublisher;
import com.netflix.zuul.stats.RequestMetricsPublisher;
import io.mantisrx.api.MantisServerStartup;
import io.mantisrx.api.services.artifacts.ArtifactManager;
import io.mantisrx.api.services.artifacts.InMemoryArtifactManager;
import io.mantisrx.api.tunnel.MantisCrossRegionalClient;
import io.mantisrx.api.tunnel.NoOpCrossRegionalClient;
import io.mantisrx.client.MantisClient;
import io.mantisrx.server.core.Configurations;
import io.mantisrx.server.core.CoreConfiguration;
import io.mantisrx.server.master.client.HighAvailabilityServices;
import io.mantisrx.server.master.client.HighAvailabilityServicesUtil;
import io.mantisrx.server.master.client.MasterClientWrapper;
import io.mantisrx.server.worker.client.WorkerMetricsClient;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.channel.Channel;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.AbstractConfiguration;
import rx.Scheduler;
import rx.schedulers.Schedulers;

public class MantisAPIModule
extends AbstractModule {
    protected void configure() {
        this.bind(AbstractConfiguration.class).toInstance((Object)ConfigurationManager.getConfigInstance());
        this.bind(BaseServerStartup.class).to(MantisServerStartup.class);
        this.bind(OriginManager.class).to(BasicNettyOriginManager.class);
        this.bind(DynamicCodeCompiler.class).to(GroovyCompiler.class);
        this.bind(FilenameFilter.class).to(GroovyFileFilter.class);
        this.install((Module)new EurekaModule());
        this.install((Module)new ZuulFiltersModule());
        this.bind(FilterLoader.class).to(DynamicFilterLoader.class);
        this.bind(FilterRegistry.class).to(MutableFilterRegistry.class);
        this.bind(FilterFileManager.class).asEagerSingleton();
        this.bind(ServerStatusManager.class);
        this.bind(SessionContextDecorator.class).to(ZuulSessionContextDecorator.class);
        this.bind(Registry.class).to(DefaultRegistry.class);
        this.bind(RequestCompleteHandler.class).to(BasicRequestCompleteHandler.class);
        this.bind(RequestMetricsPublisher.class).to(BasicRequestMetricsPublisher.class);
        this.bind(AccessLogPublisher.class).toInstance((Object)new AccessLogPublisher("ACCESS", (channel, httpRequest) -> ClientRequestReceiver.getRequestFromChannel((Channel)channel).getContext().getUUID()));
        this.bind(ArtifactManager.class).to(InMemoryArtifactManager.class);
        this.bind(MantisCrossRegionalClient.class).to(NoOpCrossRegionalClient.class);
        this.bind(ObjectMapper.class).toInstance((Object)new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false));
    }

    @Provides
    @Singleton
    MasterClientWrapper provideMantisClientWrapper(AbstractConfiguration configuration) {
        Properties props = new Properties();
        configuration.getKeys("mantis").forEachRemaining(key -> props.put(key, configuration.getString(key)));
        HighAvailabilityServices haServices = HighAvailabilityServicesUtil.createHAServices((CoreConfiguration)((CoreConfiguration)Configurations.frmProperties((Properties)props, CoreConfiguration.class)));
        return new MasterClientWrapper(haServices.getMasterClientApi());
    }

    @Provides
    @Singleton
    MantisClient provideMantisClient(AbstractConfiguration configuration) {
        Properties props = new Properties();
        configuration.getKeys("mantis").forEachRemaining(key -> props.put(key, configuration.getString(key)));
        return new MantisClient(props);
    }

    @Provides
    @Singleton
    @Named(value="io-scheduler")
    Scheduler provideIoScheduler(Registry registry) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(16, 128, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        ThreadPoolMonitor.attach((Registry)registry, (ThreadPoolExecutor)executor, (String)"io-thread-pool");
        return Schedulers.from((Executor)executor);
    }

    @Provides
    @Singleton
    WorkerMetricsClient provideWorkerMetricsClient(AbstractConfiguration configuration) {
        Properties props = new Properties();
        configuration.getKeys("mantis").forEachRemaining(key -> props.put(key, configuration.getString(key)));
        return new WorkerMetricsClient(props);
    }

    @Provides
    @Singleton
    @Named(value="push-prefixes")
    List<String> providePushPrefixes() {
        ArrayList<String> pushPrefixes = new ArrayList<String>(20);
        pushPrefixes.add("/jobconnectbyid");
        pushPrefixes.add("/api/v1/jobconnectbyid");
        pushPrefixes.add("/jobconnectbyname");
        pushPrefixes.add("/api/v1/jobconnectbyname");
        pushPrefixes.add("/jobsubmitandconnect");
        pushPrefixes.add("/api/v1/jobsubmitandconnect");
        pushPrefixes.add("/jobClusters/discoveryInfoStream");
        pushPrefixes.add("/jobstatus");
        pushPrefixes.add("/api/v1/jobstatus");
        pushPrefixes.add("/api/v1/jobs/schedulingInfo/");
        pushPrefixes.add("/api/v1/metrics");
        return pushPrefixes;
    }
}

