/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api.services;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.impl.AtomicDouble;
import com.netflix.zuul.netty.SpectatorUtils;
import io.mantisrx.api.Util;
import io.mantisrx.client.MantisClient;
import io.mantisrx.server.core.JobSchedulingInfo;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action1;
import rx.subjects.BehaviorSubject;
import rx.subjects.Subject;

public class JobDiscoveryService {
    private static final Logger log = LoggerFactory.getLogger(JobDiscoveryService.class);
    private final MantisClient mantisClient;
    private final Scheduler scheduler;
    private final AtomicDouble subjectMapSizeGauge;
    private int retryCount = 5;
    private static JobDiscoveryService INSTANCE = null;
    private final ConcurrentMap<JobDiscoveryLookupKey, JobDiscoveryInfoSubjectHolder> subjectMap = new ConcurrentHashMap<JobDiscoveryLookupKey, JobDiscoveryInfoSubjectHolder>();
    private final Action1<JobDiscoveryLookupKey> removeSubjectAction = key -> {
        if (log.isDebugEnabled()) {
            log.info("Removing subject for key {}", (Object)key.toString());
        }
        this.removeSchedulingInfoSubject((JobDiscoveryLookupKey)key);
    };
    public static final Cache<String, String> jobDiscoveryInfoCache = CacheBuilder.newBuilder().expireAfterWrite(250L, TimeUnit.MILLISECONDS).maximumSize(500L).build();

    public static synchronized JobDiscoveryService getInstance(MantisClient mantisClient, Scheduler scheduler) {
        if (INSTANCE == null) {
            INSTANCE = new JobDiscoveryService(mantisClient, scheduler);
        }
        return INSTANCE;
    }

    private JobDiscoveryService(MantisClient mClient, Scheduler scheduler) {
        Preconditions.checkNotNull((Object)mClient, (Object)"mantisClient cannot be null");
        this.mantisClient = mClient;
        this.subjectMapSizeGauge = (AtomicDouble)SpectatorUtils.newGauge((String)"mantisapi.discoveryInfo.subjectMapSize", (String)"mantisapi.discoveryInfo.subjectMapSize", (Number)new AtomicDouble(0.0));
        this.scheduler = scheduler;
    }

    @VisibleForTesting
    void setRetryCount(int cnt) {
        this.retryCount = cnt;
    }

    public Observable<JobSchedulingInfo> jobDiscoveryInfoStream(JobDiscoveryLookupKey lookupKey) {
        Preconditions.checkNotNull((Object)lookupKey, (Object)"lookup key cannot be null for fetching job discovery info");
        Preconditions.checkArgument((lookupKey.getId() != null && !lookupKey.getId().isEmpty() ? 1 : 0) != 0, (Object)("Lookup ID cannot be null or empty" + lookupKey));
        this.subjectMapSizeGauge.set((double)this.subjectMap.size());
        return this.subjectMap.computeIfAbsent(lookupKey, jc -> new JobDiscoveryInfoSubjectHolder(this.mantisClient, (JobDiscoveryLookupKey)jc, (Action1)this.removeSubjectAction, this.retryCount, this.scheduler)).jobDiscoveryInfoStream();
    }

    private void removeSchedulingInfoSubject(JobDiscoveryLookupKey lookupKey) {
        this.subjectMap.remove(lookupKey);
        this.subjectMapSizeGauge.set((double)this.subjectMap.size());
    }

    int getSubjectMapSize() {
        return this.subjectMap.size();
    }

    void clearMap() {
        this.subjectMap.clear();
    }

    public JobDiscoveryLookupKey key(LookupType lookupType, String jobCluster) {
        return new JobDiscoveryLookupKey(lookupType, jobCluster);
    }

    public class JobDiscoveryInfoSubjectHolder
    implements AutoCloseable {
        private Subscription subscription;
        private final AtomicInteger subscriberCount = new AtomicInteger();
        private final JobDiscoveryLookupKey lookupKey;
        private final MantisClient mantisClient;
        private AtomicBoolean inited = new AtomicBoolean(false);
        private CountDownLatch initComplete = new CountDownLatch(1);
        private final Action1 doOnZeroConnections;
        private final Subject<JobSchedulingInfo, JobSchedulingInfo> discoveryInfoBehaviorSubject = BehaviorSubject.create();
        private final Scheduler scheduler;
        private final Counter cleanupCounter;
        private final AtomicLong subscriberCountGauge;

        public JobDiscoveryInfoSubjectHolder(MantisClient mantisClient, JobDiscoveryLookupKey lookupKey, Action1 onZeroConnections, Scheduler scheduler) {
            this(mantisClient, lookupKey, onZeroConnections, 5, scheduler);
        }

        JobDiscoveryInfoSubjectHolder(MantisClient mantisClient, JobDiscoveryLookupKey lookupKey, Action1 onZeroConnections, int retryCount, Scheduler scheduler) {
            Preconditions.checkNotNull((Object)mantisClient, (Object)"Mantis Client cannot be null");
            Preconditions.checkNotNull((Object)lookupKey, (Object)"lookup key cannot be null");
            Preconditions.checkArgument((lookupKey.getId() != null && !lookupKey.getId().isEmpty() ? 1 : 0) != 0, (Object)"lookup key cannot be empty or null");
            Preconditions.checkNotNull((Object)onZeroConnections, (Object)"on Zero Connections callback cannot be null");
            Preconditions.checkArgument((retryCount >= 0 ? 1 : 0) != 0, (Object)"Retry count cannot be less than 0");
            this.lookupKey = lookupKey;
            this.mantisClient = mantisClient;
            this.doOnZeroConnections = onZeroConnections;
            this.scheduler = scheduler;
            this.cleanupCounter = SpectatorUtils.newCounter((String)"mantisapi.discoveryinfo.cleanupCount", (String)"", (String[])new String[]{"lookupKey", lookupKey.getId()});
            this.subscriberCountGauge = (AtomicLong)SpectatorUtils.newGauge((String)"mantisapi.discoveryinfo.subscriberCount", (String)"", (Number)new AtomicLong(0L), (String[])new String[]{"lookupKey", lookupKey.getId()});
        }

        private void init() {
            if (!this.inited.getAndSet(true)) {
                Observable jobSchedulingInfoObs;
                switch (this.lookupKey.getLookupType()) {
                    case JOB_ID: {
                        jobSchedulingInfoObs = this.mantisClient.getSchedulingChanges(this.lookupKey.getId());
                        break;
                    }
                    case JOB_CLUSTER: {
                        jobSchedulingInfoObs = this.mantisClient.jobClusterDiscoveryInfoStream(this.lookupKey.getId());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("lookup key type is not supported " + (Object)((Object)this.lookupKey.getLookupType()));
                    }
                }
                this.subscription = jobSchedulingInfoObs.retryWhen(Util.getRetryFunc(log, "job scheduling info for (" + (Object)((Object)this.lookupKey.getLookupType()) + ") " + this.lookupKey.id)).doOnError(t -> {
                    log.info("cleanup jobDiscoveryInfo onError for {}", (Object)this.lookupKey);
                    this.discoveryInfoBehaviorSubject.toSerialized().onError(t);
                    this.doOnZeroConnections.call((Object)this.lookupKey);
                }).doOnCompleted(() -> {
                    log.info("cleanup jobDiscoveryInfo onCompleted for {}", (Object)this.lookupKey);
                    this.discoveryInfoBehaviorSubject.toSerialized().onCompleted();
                    this.doOnZeroConnections.call((Object)this.lookupKey);
                }).subscribeOn(this.scheduler).subscribe(schedInfo -> this.discoveryInfoBehaviorSubject.onNext(schedInfo));
                this.initComplete.countDown();
            } else {
                try {
                    this.initComplete.await();
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage());
                }
            }
        }

        int getSubscriptionCount() {
            return this.subscriberCount.get();
        }

        public Observable<JobSchedulingInfo> jobDiscoveryInfoStream() {
            this.init();
            return this.discoveryInfoBehaviorSubject.doOnSubscribe(() -> {
                if (log.isDebugEnabled()) {
                    log.debug("Subscribed");
                }
                this.subscriberCount.incrementAndGet();
                this.subscriberCountGauge.set(this.subscriberCount.get());
                if (log.isDebugEnabled()) {
                    log.debug("Subscriber count " + this.subscriberCount.get());
                }
            }).doOnUnsubscribe(() -> {
                if (log.isDebugEnabled()) {
                    log.debug("UnSubscribed");
                }
                int subscriberCnt = this.subscriberCount.decrementAndGet();
                this.subscriberCountGauge.set(this.subscriberCount.get());
                if (log.isDebugEnabled()) {
                    log.debug("Subscriber count " + subscriberCnt);
                }
                if (0 == this.subscriberCount.get()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Shutting down");
                    }
                    this.close();
                }
            }).doOnError(t -> this.close());
        }

        @Override
        public void close() {
            if (log.isDebugEnabled()) {
                log.debug("In Close un-subscribing...." + this.subscription.isUnsubscribed());
            }
            if (this.inited.get() && this.subscription != null && !this.subscription.isUnsubscribed()) {
                if (log.isDebugEnabled()) {
                    log.debug("Unsubscribing....");
                }
                this.subscription.unsubscribe();
                this.inited.set(false);
                this.initComplete = new CountDownLatch(1);
            }
            this.cleanupCounter.increment();
            log.info("jobDiscoveryInfo close for {}", (Object)this.lookupKey);
            this.doOnZeroConnections.call((Object)this.lookupKey);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JobDiscoveryInfoSubjectHolder that = (JobDiscoveryInfoSubjectHolder)o;
            return Objects.equals(this.lookupKey, that.lookupKey);
        }

        public int hashCode() {
            return Objects.hash(this.lookupKey);
        }
    }

    public class JobSchedulingInfoSubjectHolder
    implements AutoCloseable {
        private Subscription subscription;
        private final AtomicInteger subscriberCount = new AtomicInteger();
        private final String jobId;
        private final MantisClient mantisClient;
        private AtomicBoolean inited = new AtomicBoolean(false);
        private CountDownLatch initComplete = new CountDownLatch(1);
        private final Action1 doOnZeroConnections;
        private final Subject<JobSchedulingInfo, JobSchedulingInfo> schedulingInfoBehaviorSubjectingSubject = BehaviorSubject.create();
        private final Registry registry;
        private final Scheduler scheduler;
        private final Counter cleanupCounter;
        private final AtomicLong subscriberCountGauge;

        public JobSchedulingInfoSubjectHolder(MantisClient mantisClient, String jobId, Action1 onZeroConnections, Registry registry, Scheduler scheduler) {
            this(mantisClient, jobId, onZeroConnections, 5, registry, scheduler);
        }

        JobSchedulingInfoSubjectHolder(MantisClient mantisClient, String jobId, Action1 onZeroConnections, int retryCount, Registry registry, Scheduler scheduler) {
            Preconditions.checkNotNull((Object)mantisClient, (Object)"Mantis Client cannot be null");
            Preconditions.checkNotNull((Object)jobId, (Object)"JobId cannot be null");
            Preconditions.checkArgument((!jobId.isEmpty() ? 1 : 0) != 0, (Object)"JobId cannot be empty");
            Preconditions.checkNotNull((Object)onZeroConnections, (Object)"on Zero Connections callback cannot be null");
            Preconditions.checkArgument((retryCount >= 0 ? 1 : 0) != 0, (Object)"Retry count cannot be less than 0");
            this.jobId = jobId;
            this.mantisClient = mantisClient;
            this.doOnZeroConnections = onZeroConnections;
            this.registry = registry;
            this.scheduler = scheduler;
            this.cleanupCounter = SpectatorUtils.newCounter((String)"mantisapi.schedulingChanges.cleanupCount", (String)"", (String[])new String[]{"jobId", jobId});
            this.subscriberCountGauge = (AtomicLong)SpectatorUtils.newGauge((String)"mantisapi.schedulingChanges.subscriberCount", (String)"", (Number)new AtomicLong(0L), (String[])new String[]{"jobId", jobId});
        }

        private void init() {
            if (!this.inited.getAndSet(true)) {
                this.subscription = this.mantisClient.getSchedulingChanges(this.jobId).retryWhen(Util.getRetryFunc(log, "job scheduling information for " + this.jobId)).doOnError(t -> {
                    this.schedulingInfoBehaviorSubjectingSubject.toSerialized().onError(t);
                    this.doOnZeroConnections.call((Object)this.jobId);
                }).doOnCompleted(() -> {
                    this.schedulingInfoBehaviorSubjectingSubject.toSerialized().onCompleted();
                    this.doOnZeroConnections.call((Object)this.jobId);
                }).subscribeOn(this.scheduler).subscribe(schedInfo -> this.schedulingInfoBehaviorSubjectingSubject.onNext(schedInfo));
                this.initComplete.countDown();
            } else {
                try {
                    this.initComplete.await();
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage());
                }
            }
        }

        int getSubscriptionCount() {
            return this.subscriberCount.get();
        }

        public Observable<JobSchedulingInfo> getSchedulingChanges() {
            this.init();
            return this.schedulingInfoBehaviorSubjectingSubject.doOnSubscribe(() -> {
                if (log.isDebugEnabled()) {
                    log.debug("Subscribed");
                }
                this.subscriberCount.incrementAndGet();
                this.subscriberCountGauge.set(this.subscriberCount.get());
                if (log.isDebugEnabled()) {
                    log.debug("Subscriber count " + this.subscriberCount.get());
                }
            }).doOnUnsubscribe(() -> {
                if (log.isDebugEnabled()) {
                    log.debug("UnSubscribed");
                }
                int subscriberCnt = this.subscriberCount.decrementAndGet();
                this.subscriberCountGauge.set(this.subscriberCount.get());
                if (log.isDebugEnabled()) {
                    log.debug("Subscriber count " + subscriberCnt);
                }
                if (0 == this.subscriberCount.get()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Shutting down");
                    }
                    this.close();
                }
            }).doOnError(t -> this.close());
        }

        @Override
        public void close() {
            if (log.isDebugEnabled()) {
                log.debug("In Close Unsubscribing...." + this.subscription.isUnsubscribed());
            }
            if (this.inited.get() && this.subscription != null && !this.subscription.isUnsubscribed()) {
                if (log.isDebugEnabled()) {
                    log.debug("Unsubscribing....");
                }
                this.subscription.unsubscribe();
                this.inited.set(false);
                this.initComplete = new CountDownLatch(1);
            }
            this.cleanupCounter.increment();
            this.doOnZeroConnections.call((Object)this.jobId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JobSchedulingInfoSubjectHolder that = (JobSchedulingInfoSubjectHolder)o;
            return Objects.equals(this.jobId, that.jobId);
        }

        public int hashCode() {
            return Objects.hash(this.jobId);
        }
    }

    public class JobDiscoveryLookupKey {
        private final LookupType lookupType;
        private final String id;

        public JobDiscoveryLookupKey(LookupType lookupType, String id) {
            this.lookupType = lookupType;
            this.id = id;
        }

        public LookupType getLookupType() {
            return this.lookupType;
        }

        public String getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JobDiscoveryLookupKey that = (JobDiscoveryLookupKey)o;
            return this.lookupType == that.lookupType && Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.lookupType, this.id});
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("JobDiscoveryLookupKey{");
            sb.append("lookupType=").append((Object)this.lookupType);
            sb.append(", id='").append(this.id).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    public static enum LookupType {
        JOB_CLUSTER,
        JOB_ID;

    }
}

