/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api.services;

import com.netflix.spectator.api.Counter;
import com.netflix.zuul.netty.SpectatorUtils;
import io.mantisrx.api.proto.AppDiscoveryMap;
import io.mantisrx.api.services.AppStreamStore;
import io.mantisrx.api.services.JobDiscoveryService;
import io.mantisrx.client.MantisClient;
import io.mantisrx.discovery.proto.AppJobClustersMap;
import io.mantisrx.server.core.JobSchedulingInfo;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Scheduler;

public class AppStreamDiscoveryService {
    private static final Logger log = LoggerFactory.getLogger(AppStreamDiscoveryService.class);
    private final MantisClient mantisClient;
    private final Scheduler scheduler;
    private final AppStreamStore appStreamStore;

    public AppStreamDiscoveryService(MantisClient mantisClient, Scheduler scheduler, AppStreamStore appStreamStore) {
        this.mantisClient = mantisClient;
        this.scheduler = scheduler;
        this.appStreamStore = appStreamStore;
        Counter appJobClusterMappingNullCount = SpectatorUtils.newCounter((String)"appJobClusterMappingNull", (String)"mantisapi");
        Counter appJobClusterMappingRequestCount = SpectatorUtils.newCounter((String)"appJobClusterMappingRequest", (String)"mantisapi", (String[])new String[]{"app", "unknown"});
        Counter appJobClusterMappingFailCount = SpectatorUtils.newCounter((String)"appJobClusterMappingFail", (String)"mantisapi");
    }

    public Either<String, AppDiscoveryMap> getAppDiscoveryMap(List<String> appNames) {
        try {
            AppJobClustersMap appJobClusters = this.getAppJobClustersMap(appNames);
            AppDiscoveryMap adm = new AppDiscoveryMap(appJobClusters.getVersion(), appJobClusters.getTimestamp());
            for (String app : appJobClusters.getMappings().keySet()) {
                for (String stream : ((Map)appJobClusters.getMappings().get(app)).keySet()) {
                    String jobCluster = (String)((Map)appJobClusters.getMappings().get(app)).get(stream);
                    Option<JobSchedulingInfo> jobSchedulingInfo = this.getJobDiscoveryInfo(jobCluster);
                    jobSchedulingInfo.map(jsi -> {
                        adm.addMapping(app, stream, (JobSchedulingInfo)jsi);
                        return jsi;
                    });
                }
            }
            return Either.right((Object)adm);
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
            return Either.left((Object)ex.getMessage());
        }
    }

    public AppJobClustersMap getAppJobClustersMap(List<String> appNames) throws IOException {
        return this.appStreamStore.getJobClusterMappings(appNames);
    }

    private Option<JobSchedulingInfo> getJobDiscoveryInfo(String jobCluster) {
        JobDiscoveryService jdim = JobDiscoveryService.getInstance(this.mantisClient, this.scheduler);
        return (Option)jdim.jobDiscoveryInfoStream(jdim.key(JobDiscoveryService.LookupType.JOB_CLUSTER, jobCluster)).map(Option::of).take(1).timeout(2L, TimeUnit.SECONDS, Observable.just((Object)Option.none())).doOnError(t -> log.warn("Timed out looking up job discovery info for cluster: " + jobCluster + ".")).subscribeOn(this.scheduler).observeOn(this.scheduler).toSingle().toBlocking().value();
    }
}

