/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api;

import com.google.inject.Module;
import com.netflix.config.ConfigurationManager;
import com.netflix.governator.InjectorBuilder;
import com.netflix.governator.LifecycleInjector;
import com.netflix.zuul.netty.server.BaseServerStartup;
import com.netflix.zuul.netty.server.Server;
import io.mantisrx.api.MantisAPIModule;

public class Bootstrap {
    public static void main(String[] args) {
        new Bootstrap().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        System.out.println("Mantis API: starting up.");
        long startTime = System.currentTimeMillis();
        int exitCode = 0;
        Server server = null;
        try {
            ConfigurationManager.loadCascadedPropertiesFromResources((String)"application");
            LifecycleInjector injector = InjectorBuilder.fromModule((Module)new MantisAPIModule()).createInjector();
            BaseServerStartup serverStartup = (BaseServerStartup)injector.getInstance(BaseServerStartup.class);
            server = serverStartup.server();
            long startupDuration = System.currentTimeMillis() - startTime;
            System.out.println("Mantis API: finished startup. Duration = " + startupDuration + " ms");
            server.start();
            server.awaitTermination();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println("###############");
            System.err.println("Mantis API: initialization failed. Forcing shutdown now.");
            System.err.println("###############");
            exitCode = 1;
        }
        finally {
            if (server != null) {
                server.stop();
            }
            System.exit(exitCode);
        }
    }
}

