/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api.filters;

import com.netflix.zuul.filters.http.HttpOutboundSyncFilter;
import com.netflix.zuul.message.HeaderName;
import com.netflix.zuul.message.http.HttpResponseMessage;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.AsciiString;

public class OutboundHeaders
extends HttpOutboundSyncFilter {
    public boolean shouldFilter(HttpResponseMessage msg) {
        return true;
    }

    public HttpResponseMessage apply(HttpResponseMessage resp) {
        this.upsert(resp, HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        this.addHeaderIfMissing(resp, HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, "Origin, X-Requested-With, Accept, Content-Type, Cache-Control");
        this.addHeaderIfMissing(resp, HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS, "GET, OPTIONS, PUT, POST, DELETE, CONNECT");
        this.addHeaderIfMissing(resp, HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        return resp;
    }

    private void upsert(HttpResponseMessage resp, AsciiString name, String value) {
        resp.getHeaders().remove(new HeaderName(name.toString()));
        resp.getHeaders().add(new HeaderName(name.toString()), value);
    }

    private void addHeaderIfMissing(HttpResponseMessage resp, AsciiString name, String value) {
        if (resp.getHeaders().getAll(name.toString()).size() == 0) {
            resp.getHeaders().add(name.toString(), value);
        }
    }

    public int filterOrder() {
        return 0;
    }
}

