/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api;

import com.google.common.base.Strings;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.functions.Func1;

public final class Util {
    private static final Logger log = LoggerFactory.getLogger(Util.class);
    private static final int defaultNumRetries = 2;

    public static boolean startsWithAnyOf(String target, List<String> prefixes) {
        for (String prefix : prefixes) {
            if (!target.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static String getLocalRegion() {
        return System.getenv("EC2_REGION");
    }

    public static boolean isAllRegion(String region) {
        return region != null && region.trim().equalsIgnoreCase("all");
    }

    public static String[] getTaglist(String uri, String id) {
        return Util.getTaglist(uri, id, null);
    }

    public static String[] getTaglist(String uri, String id, String region) {
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(uri);
        Map queryParameters = queryStringDecoder.parameters();
        boolean isClientIdSet = false;
        LinkedList<String> tags = new LinkedList<String>();
        if (queryParameters != null) {
            List tagVals = (List)queryParameters.get("MantisApiTag");
            if (tagVals != null) {
                for (String s : tagVals) {
                    StringTokenizer tokenizer = new StringTokenizer(s, ":");
                    if (tokenizer.countTokens() != 2) continue;
                    String s1 = tokenizer.nextToken();
                    String s2 = tokenizer.nextToken();
                    if (s1 == null || s1.isEmpty() || s2 == null || s2.isEmpty()) continue;
                    tags.add(s1);
                    tags.add(s2);
                    if (!"clientId".equals(s1)) continue;
                    isClientIdSet = true;
                }
            }
            tagVals = (List)queryParameters.get("clientId");
            if (!isClientIdSet && tagVals != null && !tagVals.isEmpty()) {
                tags.add("clientId");
                tags.add((String)tagVals.get(0));
            }
        }
        tags.add("SessionId");
        tags.add(id);
        tags.add("urlPath");
        tags.add(queryStringDecoder.path());
        if (!Strings.isNullOrEmpty((String)region)) {
            tags.add("region");
            tags.add(region);
        }
        return tags.toArray(new String[0]);
    }

    public static Func1<Observable<? extends Throwable>, Observable<?>> getRetryFunc(Logger logger, String name) {
        return Util.getRetryFunc(logger, name, 2);
    }

    public static Func1<Observable<? extends Throwable>, Observable<?>> getRetryFunc(Logger logger, String name, int retries) {
        int limit = retries == Integer.MAX_VALUE ? retries : retries + 1;
        return attempts -> attempts.zipWith(Observable.range((int)1, (int)limit), (t1, integer) -> {
            logger.warn("Caught exception connecting for {}.", (Object)name, t1);
            return new ImmutablePair(t1, integer);
        }).flatMap(pair -> {
            Throwable t = (Throwable)pair.left;
            int retryIter = (Integer)pair.right;
            long delay = Math.round(Math.pow(2.0, retryIter));
            if (retryIter > retries) {
                logger.error("Exceeded maximum retries ({}) for {} with exception: {}", new Object[]{retries, name, t.getMessage(), t});
                return Observable.error((Throwable)new Exception("Timeout after " + retries + " retries"));
            }
            logger.info("Retrying connection to {} after sleeping for {} seconds.", new Object[]{name, delay, t});
            return Observable.timer((long)delay, (TimeUnit)TimeUnit.SECONDS);
        });
    }

    private Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

