/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api.filters;

import com.google.inject.Inject;
import com.netflix.mantis.discovery.proto.AppJobClustersMap;
import com.netflix.zuul.filters.http.HttpSyncEndpoint;
import com.netflix.zuul.message.http.HttpHeaderNames;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.message.http.HttpResponseMessageImpl;
import io.mantisrx.api.services.AppStreamDiscoveryService;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.List;

public class MREAppStreamToJobClusterMapping
extends HttpSyncEndpoint {
    private final AppStreamDiscoveryService appStreamDiscoveryService;
    private final ObjectMapper objectMapper;
    private static final String APPNAME_QUERY_PARAM = "app";
    public static final String PATH_SPEC = "/api/v1/mantis/publish/streamJobClusterMap";

    @Inject
    public MREAppStreamToJobClusterMapping(AppStreamDiscoveryService appStreamDiscoveryService, ObjectMapper objectMapper) {
        this.appStreamDiscoveryService = appStreamDiscoveryService;
        this.objectMapper = objectMapper;
    }

    public HttpResponseMessage apply(HttpRequestMessage request) {
        List apps = request.getQueryParams().get(APPNAME_QUERY_PARAM);
        AppJobClustersMap payload = this.appStreamDiscoveryService.getAppJobClustersMap(apps);
        Try serialized = Try.of((CheckedFunction0 & Serializable)() -> this.objectMapper.writeValueAsString((Object)payload));
        return (HttpResponseMessage)serialized.map(body -> {
            HttpResponseMessageImpl resp = new HttpResponseMessageImpl(request.getContext(), request, 200);
            resp.setBodyAsText(body);
            resp.getHeaders().set(HttpHeaderNames.CONTENT_TYPE.toString(), HttpHeaderValues.APPLICATION_JSON.toString());
            return resp;
        }).getOrElseGet(t -> {
            HttpResponseMessageImpl resp = new HttpResponseMessageImpl(request.getContext(), request, 200);
            resp.setBodyAsText(t.getMessage());
            resp.getHeaders().set(HttpHeaderNames.CONTENT_TYPE.toString(), HttpHeaderValues.TEXT_PLAIN.toString());
            return resp;
        });
    }
}

