/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api.services;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.netflix.config.DynamicStringProperty;
import com.netflix.mantis.discovery.proto.AppJobClustersMap;
import com.netflix.spectator.api.Counter;
import com.netflix.zuul.netty.SpectatorUtils;
import io.mantisrx.api.proto.AppDiscoveryMap;
import io.mantisrx.api.services.JobDiscoveryService;
import io.mantisrx.client.MantisClient;
import io.mantisrx.server.core.JobSchedulingInfo;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Scheduler;

public class AppStreamDiscoveryService {
    private static final Logger log = LoggerFactory.getLogger(AppStreamDiscoveryService.class);
    private static final String APP_JOB_CLUSTER_MAPPING_KEY = "mreAppJobClusterMap";
    private final AtomicReference<AppJobClustersMap> appJobClusterMappings = new AtomicReference();
    private final MantisClient mantisClient;
    private final Scheduler scheduler;
    private final ObjectMapper objectMapper;
    private final Counter appJobClusterMappingNullCount;
    private final Counter appJobClusterMappingRequestCount;
    private final Counter appJobClusterMappingFailCount;
    private final DynamicStringProperty appJobClustersProp = new DynamicStringProperty("mreAppJobClusterMap", "");

    @Inject
    public AppStreamDiscoveryService(MantisClient mantisClient, @Named(value="io-scheduler") Scheduler scheduler, ObjectMapper objectMapper) {
        this.mantisClient = mantisClient;
        this.scheduler = scheduler;
        this.objectMapper = objectMapper;
        this.appJobClusterMappingNullCount = SpectatorUtils.newCounter((String)"appJobClusterMappingNull", (String)"mantisapi");
        this.appJobClusterMappingRequestCount = SpectatorUtils.newCounter((String)"appJobClusterMappingRequest", (String)"mantisapi", (String[])new String[]{"app", "unknown"});
        this.appJobClusterMappingFailCount = SpectatorUtils.newCounter((String)"appJobClusterMappingFail", (String)"mantisapi");
        this.updateAppJobClustersMapping(this.appJobClustersProp.get());
        this.appJobClustersProp.addCallback(() -> this.updateAppJobClustersMapping(this.appJobClustersProp.get()));
    }

    private void updateAppJobClustersMapping(String appJobClusterStr) {
        if (appJobClusterStr != null) {
            try {
                AppJobClustersMap appJobClustersMap = (AppJobClustersMap)this.objectMapper.readValue(appJobClusterStr, AppJobClustersMap.class);
                log.info("appJobClustersMap updated to {}", (Object)appJobClustersMap);
                this.appJobClusterMappings.set(appJobClustersMap);
            }
            catch (Exception ioe) {
                log.error("failed to update appJobClustersMap on Property update {}", (Object)appJobClusterStr, (Object)ioe);
                this.appJobClusterMappingFailCount.increment();
            }
        } else {
            log.error("appJobCluster mapping property is NULL");
            this.appJobClusterMappingNullCount.increment();
        }
    }

    public Either<String, AppDiscoveryMap> getAppDiscoveryMap(List<String> appNames) {
        try {
            AppJobClustersMap appJobClustersMap = this.appJobClusterMappings.get();
            if (appJobClustersMap == null) {
                log.error("appJobCluster Mapping is null");
                this.appJobClusterMappingNullCount.increment();
                return Either.left((Object)"appJobCluster Mapping is null.");
            }
            AppJobClustersMap appJobClusters = this.getAppJobClustersMap(appNames, appJobClustersMap);
            AppDiscoveryMap adm = new AppDiscoveryMap(appJobClusters.getVersion(), appJobClusters.getTimestamp());
            for (String app : appJobClusters.getMappings().keySet()) {
                for (String stream : ((Map)appJobClusters.getMappings().get(app)).keySet()) {
                    String jobCluster = (String)((Map)appJobClusters.getMappings().get(app)).get(stream);
                    Option<JobSchedulingInfo> jobSchedulingInfo = this.getJobDiscoveryInfo(jobCluster);
                    jobSchedulingInfo.map(jsi -> {
                        adm.addMapping(app, stream, (JobSchedulingInfo)jsi);
                        return jsi;
                    });
                }
            }
            return Either.right((Object)adm);
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
            return Either.left((Object)ex.getMessage());
        }
    }

    public AppJobClustersMap getAppJobClustersMap(List<String> appNames) {
        return this.getAppJobClustersMap(appNames, this.appJobClusterMappings.get());
    }

    public AppJobClustersMap getAppJobClustersMap(List<String> appNames, AppJobClustersMap appJobClustersMap) {
        AppJobClustersMap appJobClusters;
        if (appNames.size() > 0) {
            appJobClusters = appJobClustersMap.getFilteredAppJobClustersMap(appNames);
        } else {
            this.appJobClusterMappingRequestCount.increment();
            appJobClusters = appJobClustersMap;
        }
        return appJobClusters;
    }

    private Option<JobSchedulingInfo> getJobDiscoveryInfo(String jobCluster) {
        JobDiscoveryService jdim = JobDiscoveryService.getInstance(this.mantisClient, this.scheduler);
        return (Option)jdim.jobDiscoveryInfoStream(jdim.key(JobDiscoveryService.LookupType.JOB_CLUSTER, jobCluster)).map(Option::of).take(1).timeout(2L, TimeUnit.SECONDS, Observable.just((Object)Option.none())).doOnError(t -> log.warn("Timed out looking up job discovery info for cluster: " + jobCluster + ".")).subscribeOn(this.scheduler).observeOn(this.scheduler).toSingle().toBlocking().value();
    }
}

