/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api.filters;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.spectator.api.Counter;
import com.netflix.zuul.filters.http.HttpInboundSyncFilter;
import com.netflix.zuul.message.http.HttpHeaderNames;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.message.http.HttpResponseMessageImpl;
import com.netflix.zuul.netty.SpectatorUtils;
import io.mantisrx.api.Util;
import io.mantisrx.api.filters.MasterCacheLoader;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterCacheHitChecker
extends HttpInboundSyncFilter {
    private static final Logger log = LoggerFactory.getLogger(MasterCacheHitChecker.class);
    private static DynamicBooleanProperty cacheEnabled = new DynamicBooleanProperty("mantisapi.cache.enabled", false);
    private static final ConcurrentHashMap<String, Counter> cacheHitCounters = new ConcurrentHashMap(500);
    private static final ConcurrentHashMap<String, Counter> cacheMissCounters = new ConcurrentHashMap(500);
    private static final String CACHE_HIT_COUNTER_NAME = "mantis.api.cache.count";
    private final List<String> pushPrefixes;

    @Inject
    public MasterCacheHitChecker(@Named(value="push-prefixes") List<String> pushPrefixes) {
        this.pushPrefixes = pushPrefixes;
    }

    public HttpRequestMessage apply(HttpRequestMessage request) {
        if (cacheEnabled.get()) {
            String key = request.getPathAndQuery();
            String bodyText = (String)MasterCacheLoader.masterCache.getIfPresent((Object)key);
            if (bodyText != null) {
                HttpResponseMessageImpl response = new HttpResponseMessageImpl(request.getContext(), request, 200);
                response.setBodyAsText(bodyText);
                response.getHeaders().set(HttpHeaderNames.CONTENT_TYPE.toString(), HttpHeaderValues.APPLICATION_JSON.toString());
                response.getHeaders().set("x-nflx-mantisapi-cached", "true");
                request.getContext().setStaticResponse((HttpResponseMessage)response);
                cacheHitCounters.computeIfAbsent(key, k -> SpectatorUtils.newCounter((String)CACHE_HIT_COUNTER_NAME, (String)"api", (String[])new String[]{"endpoint", k, "class", "hit"})).increment();
            } else {
                cacheMissCounters.computeIfAbsent(key, k -> SpectatorUtils.newCounter((String)CACHE_HIT_COUNTER_NAME, (String)"api", (String[])new String[]{"endpoint", k, "class", "miss"})).increment();
            }
        }
        return request;
    }

    public int filterOrder() {
        return 0;
    }

    public boolean shouldFilter(HttpRequestMessage msg) {
        String key = msg.getPathAndQuery();
        return msg.getMethod().equalsIgnoreCase("get") && key.startsWith("/api") && !Util.startsWithAnyOf(key, this.pushPrefixes);
    }
}

