/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api.initializers;

import com.netflix.netty.common.HttpLifecycleChannelHandler;
import com.netflix.netty.common.channel.config.ChannelConfig;
import com.netflix.netty.common.channel.config.CommonChannelConfigKeys;
import com.netflix.zuul.netty.server.BaseZuulChannelInitializer;
import com.netflix.zuul.netty.ssl.SslContextFactory;
import io.mantisrx.api.Util;
import io.mantisrx.api.push.ConnectionBroker;
import io.mantisrx.api.push.MantisSSEHandler;
import io.mantisrx.api.push.MantisWebSocketFrameHandler;
import io.mantisrx.api.tunnel.CrossRegionHandler;
import io.mantisrx.api.tunnel.MantisCrossRegionalClient;
import io.mantisrx.client.MantisClient;
import io.mantisrx.server.master.client.MasterClientWrapper;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.List;
import javax.net.ssl.SSLException;
import rx.Scheduler;

public class MantisApiServerChannelInitializer
extends BaseZuulChannelInitializer {
    private final SslContextFactory sslContextFactory;
    private final SslContext sslContext;
    private final boolean isSSlFromIntermediary;
    private final ConnectionBroker connectionBroker;
    private final MasterClientWrapper masterClientWrapper;
    private final MantisCrossRegionalClient mantisCrossRegionalClient;
    private final Scheduler scheduler;
    private final List<String> pushPrefixes;
    private final boolean sslEnabled;

    public MantisApiServerChannelInitializer(String metricId, ChannelConfig channelConfig, ChannelConfig channelDependencies, ChannelGroup channels, List<String> pushPrefixes, MantisClient mantisClient, MasterClientWrapper masterClientWrapper, MantisCrossRegionalClient mantisCrossRegionalClient, ConnectionBroker connectionBroker, Scheduler scheduler, boolean sslEnabled) {
        super(metricId, channelConfig, channelDependencies, channels);
        this.pushPrefixes = pushPrefixes;
        this.connectionBroker = connectionBroker;
        this.masterClientWrapper = masterClientWrapper;
        this.mantisCrossRegionalClient = mantisCrossRegionalClient;
        this.scheduler = scheduler;
        this.sslEnabled = sslEnabled;
        this.isSSlFromIntermediary = (Boolean)channelConfig.get(CommonChannelConfigKeys.isSSlFromIntermediary);
        this.sslContextFactory = (SslContextFactory)channelConfig.get(CommonChannelConfigKeys.sslContextFactory);
        if (sslEnabled) {
            try {
                this.sslContext = this.sslContextFactory.createBuilderForServer().build();
            }
            catch (SSLException e) {
                throw new RuntimeException("Error configuring SslContext!", e);
            }
            this.sslContextFactory.enableSessionTickets(this.sslContext);
            this.sslContextFactory.configureOpenSslStatsMetrics(this.sslContext, metricId);
        } else {
            this.sslContext = null;
        }
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        this.storeChannel(ch);
        this.addTimeoutHandlers(pipeline);
        this.addPassportHandler(pipeline);
        this.addTcpRelatedHandlers(pipeline);
        if (this.sslEnabled) {
            SslHandler sslHandler = this.sslContext.newHandler(ch.alloc());
            sslHandler.engine().setEnabledProtocols(this.sslContextFactory.getProtocols());
            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
            this.addSslInfoHandlers(pipeline, this.isSSlFromIntermediary);
            this.addSslClientCertChecks(pipeline);
        }
        this.addHttp1Handlers(pipeline);
        this.addHttpRelatedHandlers(pipeline);
        pipeline.addLast("mantishandler", (ChannelHandler)new MantisChannelHandler(this.pushPrefixes));
    }

    protected void addPushHandlers(ChannelPipeline pipeline, String url) {
        pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
        pipeline.addLast(new ChannelHandler[]{new MantisSSEHandler(this.connectionBroker, this.masterClientWrapper, this.pushPrefixes)});
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(url, true)});
        pipeline.addLast(new ChannelHandler[]{new MantisWebSocketFrameHandler(this.connectionBroker)});
    }

    protected void addRegionalHandlers(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(0xA00000)});
        pipeline.addLast(new ChannelHandler[]{new CrossRegionHandler(this.pushPrefixes, this.mantisCrossRegionalClient, this.connectionBroker, this.scheduler)});
    }

    private void removeEverythingAfterThis(ChannelPipeline pipeline) {
        while (pipeline.last().getClass() != MantisChannelHandler.class) {
            pipeline.removeLast();
        }
    }

    @ChannelHandler.Sharable
    public class MantisChannelHandler
    extends ChannelInboundHandlerAdapter {
        private final List<String> pushPrefixes;

        public MantisChannelHandler(List<String> pushPrefixes) {
            this.pushPrefixes = pushPrefixes;
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof HttpLifecycleChannelHandler.StartEvent) {
                HttpLifecycleChannelHandler.StartEvent startEvent = (HttpLifecycleChannelHandler.StartEvent)evt;
                String uri = startEvent.getRequest().uri();
                ChannelPipeline pipeline = ctx.pipeline();
                MantisApiServerChannelInitializer.this.removeEverythingAfterThis(pipeline);
                if (Util.startsWithAnyOf(uri, this.pushPrefixes)) {
                    MantisApiServerChannelInitializer.this.addPushHandlers(pipeline, uri);
                } else if (uri.startsWith("/region/")) {
                    MantisApiServerChannelInitializer.this.addRegionalHandlers(pipeline);
                } else {
                    MantisApiServerChannelInitializer.this.addZuulHandlers(pipeline);
                }
            }
            ctx.fireUserEventTriggered(evt);
        }
    }
}

