/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.api;

import com.google.inject.name.Named;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.config.DynamicIntProperty;
import com.netflix.discovery.EurekaClient;
import com.netflix.netty.common.accesslog.AccessLogPublisher;
import com.netflix.netty.common.channel.config.ChannelConfig;
import com.netflix.netty.common.channel.config.CommonChannelConfigKeys;
import com.netflix.netty.common.metrics.EventLoopGroupMetrics;
import com.netflix.netty.common.proxyprotocol.StripUntrustedProxyHeadersHandler;
import com.netflix.netty.common.status.ServerStatusManager;
import com.netflix.spectator.api.Registry;
import com.netflix.zuul.FilterLoader;
import com.netflix.zuul.FilterUsageNotifier;
import com.netflix.zuul.RequestCompleteHandler;
import com.netflix.zuul.context.SessionContextDecorator;
import com.netflix.zuul.netty.server.BaseServerStartup;
import com.netflix.zuul.netty.server.DirectMemoryMonitor;
import com.netflix.zuul.netty.server.NamedSocketAddress;
import io.mantisrx.api.initializers.MantisApiServerChannelInitializer;
import io.mantisrx.api.push.ConnectionBroker;
import io.mantisrx.api.tunnel.MantisCrossRegionalClient;
import io.mantisrx.client.MantisClient;
import io.mantisrx.server.master.client.MasterClientWrapper;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.group.ChannelGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.configuration.AbstractConfiguration;
import rx.Scheduler;

@Singleton
public class MantisServerStartup
extends BaseServerStartup {
    private final MantisClient mantisClient;
    private final MasterClientWrapper masterClientWrapper;
    private final MantisCrossRegionalClient mantisCrossRegionalClient;
    private final ConnectionBroker connectionBroker;
    private final Scheduler scheduler;
    private final List<String> pushPrefixes;

    @Inject
    public MantisServerStartup(ServerStatusManager serverStatusManager, FilterLoader filterLoader, SessionContextDecorator sessionCtxDecorator, FilterUsageNotifier usageNotifier, RequestCompleteHandler reqCompleteHandler, Registry registry, DirectMemoryMonitor directMemoryMonitor, EventLoopGroupMetrics eventLoopGroupMetrics, EurekaClient discoveryClient, ApplicationInfoManager applicationInfoManager, AccessLogPublisher accessLogPublisher, AbstractConfiguration configurationManager, MasterClientWrapper masterClientWrapper, MantisClient mantisClient, MantisCrossRegionalClient mantisCrossRegionalClient, ConnectionBroker connectionBroker, @Named(value="io-scheduler") Scheduler scheduler, @Named(value="push-prefixes") List<String> pushPrefixes) {
        super(serverStatusManager, filterLoader, sessionCtxDecorator, usageNotifier, reqCompleteHandler, registry, directMemoryMonitor, eventLoopGroupMetrics, discoveryClient, applicationInfoManager, accessLogPublisher);
        this.mantisClient = mantisClient;
        this.masterClientWrapper = masterClientWrapper;
        this.mantisCrossRegionalClient = mantisCrossRegionalClient;
        this.connectionBroker = connectionBroker;
        this.scheduler = scheduler;
        this.pushPrefixes = pushPrefixes;
        masterClientWrapper.getMasterMonitor().getMasterObservable().filter(x -> x != null).forEach(masterDescription -> {
            LOG.info("Received new Mantis Master: " + masterDescription);
            configurationManager.setProperty("api.ribbon.listOfServers", (Object)(masterDescription.getHostIP() + ":" + masterDescription.getApiPort()));
        });
    }

    protected Map<NamedSocketAddress, ChannelInitializer<?>> chooseAddrsAndChannels(ChannelGroup clientChannels) {
        HashMap<NamedSocketAddress, MantisApiServerChannelInitializer> addrsToChannels = new HashMap<NamedSocketAddress, MantisApiServerChannelInitializer>();
        String mainPortName = "main";
        int port = new DynamicIntProperty("zuul.server.port.main", 7001).get();
        NamedSocketAddress sockAddr = new NamedSocketAddress(mainPortName, (SocketAddress)new InetSocketAddress(port));
        ChannelConfig channelConfig = MantisServerStartup.defaultChannelConfig((String)mainPortName);
        ChannelConfig channelDependencies = this.defaultChannelDependencies(mainPortName);
        channelConfig.set(CommonChannelConfigKeys.allowProxyHeadersWhen, (Object)StripUntrustedProxyHeadersHandler.AllowWhen.ALWAYS);
        channelConfig.set(CommonChannelConfigKeys.preferProxyProtocolForClientIp, (Object)false);
        channelConfig.set(CommonChannelConfigKeys.isSSlFromIntermediary, (Object)false);
        channelConfig.set(CommonChannelConfigKeys.withProxyProtocol, (Object)false);
        addrsToChannels.put(sockAddr, new MantisApiServerChannelInitializer(String.valueOf(port), channelConfig, channelDependencies, clientChannels, this.pushPrefixes, this.mantisClient, this.masterClientWrapper, this.mantisCrossRegionalClient, this.connectionBroker, this.scheduler, false));
        this.logAddrConfigured((SocketAddress)sockAddr);
        return Collections.unmodifiableMap(addrsToChannels);
    }
}

