/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.spring.annotation;

import io.manbang.ebatis.spring.annotation.EasyMapperBeanDefinitionScanner;
import io.manbang.ebatis.spring.annotation.EnableEasyMapper;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

class EasyMapperRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Logger log = LoggerFactory.getLogger(EasyMapperRegistrar.class);

    EasyMapperRegistrar() {
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes mapperAttributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(EnableEasyMapper.class.getName(), false));
        metadata.isIndependent();
        new EasyMapperBeanDefinitionScanner(registry, this.getClusterName(mapperAttributes)).scan(this.getPackagesToScan(mapperAttributes, metadata));
    }

    private String getClusterName(AnnotationAttributes mapperAttributes) {
        return mapperAttributes.getString("clusterRouter");
    }

    private String[] getPackagesToScan(AnnotationAttributes attributes, AnnotationMetadata metadata) {
        Set<String> packages = Stream.of(attributes.getStringArray("basePackages")).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        if (packages.isEmpty()) {
            return new String[]{metadata.getClassName().substring(0, metadata.getClassName().lastIndexOf(46))};
        }
        return packages.toArray(new String[0]);
    }
}

