/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.spring.cluster;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.context.ApplicationContext;

class ApplicationContextDelegate {
    private static final AtomicReference<ApplicationContext> CONTEXT_HOLDER = new AtomicReference();

    private ApplicationContextDelegate() {
        throw new UnsupportedOperationException();
    }

    static <T> T getBean(String name, Class<T> beanClass) {
        return Optional.ofNullable(CONTEXT_HOLDER.get()).map(context -> context.getBean(name, beanClass)).orElse(null);
    }

    static <T> T getBean(Class<T> beanClass) {
        return Optional.ofNullable(CONTEXT_HOLDER.get()).map(context -> context.getBean(beanClass)).orElse(null);
    }

    static void setContext(ApplicationContext context) {
        CONTEXT_HOLDER.compareAndSet(null, context);
    }
}

