/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.spring.cluster;

import com.google.auto.service.AutoService;
import io.manbang.ebatis.core.cluster.ClusterRouter;
import io.manbang.ebatis.core.cluster.ClusterRouterProvider;
import io.manbang.ebatis.spring.cluster.ApplicationContextDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@AutoService(value={ClusterRouterProvider.class})
public class SpringClusterRouterProvider
implements ClusterRouterProvider,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringClusterRouterProvider.class);

    public ClusterRouter getClusterRouter(String name) {
        try {
            return ApplicationContextDelegate.getBean(name, ClusterRouter.class);
        }
        catch (NoSuchBeanDefinitionException ignore) {
            return null;
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u96c6\u7fa4\u8def\u7531\u5931\u8d25\uff1a{}", (Object)name, (Object)e);
            throw e;
        }
    }

    public void setApplicationContext(ApplicationContext context) {
        ApplicationContextDelegate.setContext(context);
    }
}

