/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.spring.annotation;

import io.manbang.ebatis.core.annotation.Mapper;
import io.manbang.ebatis.spring.annotation.EasyMapper;
import io.manbang.ebatis.spring.exception.ClusterRouterNameNotSetException;
import io.manbang.ebatis.spring.proxy.EasyMapperProxyFactoryBean;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class EasyMapperBeanDefinitionScanner
extends ClassPathBeanDefinitionScanner {
    private static final Logger log = LoggerFactory.getLogger(EasyMapperBeanDefinitionScanner.class);
    private static final String CLUSTER_ROUTER_ATTRIBUTE_NAME = "clusterRouter";
    private final String globalClusterRouter;

    public EasyMapperBeanDefinitionScanner(BeanDefinitionRegistry registry, String globalClusterRouter) {
        super(registry, false);
        this.globalClusterRouter = globalClusterRouter;
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Mapper.class));
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(EasyMapper.class));
    }

    protected void registerBeanDefinition(BeanDefinitionHolder definitionHolder, BeanDefinitionRegistry registry) {
        AnnotatedBeanDefinition beanDefinition = (AnnotatedBeanDefinition)definitionHolder.getBeanDefinition();
        String beanClassName = beanDefinition.getBeanClassName();
        String clusterRouter = AnnotationAttributes.fromMap((Map)beanDefinition.getMetadata().getAnnotationAttributes(Mapper.class.getName())).getString(CLUSTER_ROUTER_ATTRIBUTE_NAME);
        beanDefinition.setBeanClassName(EasyMapperProxyFactoryBean.class.getName());
        ConstructorArgumentValues constructorArgumentValues = beanDefinition.getConstructorArgumentValues();
        constructorArgumentValues.addGenericArgumentValue((Object)beanClassName);
        constructorArgumentValues.addGenericArgumentValue((Object)this.getClusterRouter(clusterRouter));
        super.registerBeanDefinition(definitionHolder, registry);
    }

    private String getClusterRouter(String clusterRouter) {
        String name;
        String string = name = StringUtils.isEmpty((CharSequence)clusterRouter) ? this.globalClusterRouter : clusterRouter;
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new ClusterRouterNameNotSetException();
        }
        return name;
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        AnnotationMetadata metadata = beanDefinition.getMetadata();
        return metadata.isIndependent() && metadata.isInterface();
    }
}

