/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.spring.boot.autoconfigure;

import io.manbang.ebatis.core.cluster.Cluster;
import io.manbang.ebatis.core.cluster.ClusterRouter;
import io.manbang.ebatis.core.cluster.WeightedCluster;
import io.manbang.ebatis.spring.annotation.EasyMapperBeanDefinitionScanner;
import io.manbang.ebatis.spring.boot.autoconfigure.EbatisProperties;
import io.manbang.ebatis.spring.proxy.EasyMapperProxyFactoryBean;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

@Configuration
@EnableConfigurationProperties(value={EbatisProperties.class})
@ConditionalOnClass(value={Cluster.class, EasyMapperProxyFactoryBean.class})
public class EbatisAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EbatisAutoConfiguration.class);
    public static final int DEFAULT_PORT = 9200;
    private static final String DEFAULT_CLUSTER_ROUTER_NAME = "clusterRouter";
    private static final String EBATIS_CLUSTER_PREFIX = "ebatis.cluster";
    private final EbatisProperties properties;

    public EbatisAutoConfiguration(EbatisProperties properties) {
        this.properties = properties;
    }

    private static HttpHost[] toHttpHosts(String hosts) {
        return (HttpHost[])Stream.of(hosts.split(",")).filter(StringUtils::isNotBlank).map(host -> host.split(":")).map(endpoint -> new EsHost(endpoint[0].trim(), Integer.parseInt(endpoint[1].trim()))).map(EsHost::toHttpHost).toArray(HttpHost[]::new);
    }

    private static WeightedCluster toWeightedClusters(String weightedHosts) {
        String[] strings = weightedHosts.split("@");
        int weight = Integer.parseInt(strings[0]);
        HttpHost[] httpHosts = EbatisAutoConfiguration.toHttpHosts(strings[1]);
        return Cluster.weighted((int)weight, (HttpHost[])httpHosts);
    }

    @Bean(name={"clusterRouter"}, destroyMethod="close")
    @ConditionalOnMissingBean(value={ClusterRouter.class})
    @ConditionalOnProperty(prefix="ebatis.cluster", name={"single"})
    public ClusterRouter singleClusterRouter() {
        HttpHost[] httpHosts = EbatisAutoConfiguration.toHttpHosts(this.properties.getCluster().getSingle());
        Cluster cluster = Cluster.simple((HttpHost[])httpHosts);
        return ClusterRouter.single((Cluster)cluster);
    }

    @Bean(name={"clusterRouter"}, destroyMethod="close")
    @ConditionalOnMissingBean(value={ClusterRouter.class})
    @ConditionalOnProperty(prefix="ebatis.cluster", name={"random[0]"})
    public ClusterRouter randomClusterRouter() {
        Cluster[] clusters = (Cluster[])Stream.of(this.properties.getCluster().getRandom()).map(EbatisAutoConfiguration::toHttpHosts).map(Cluster::simple).toArray(Cluster[]::new);
        return ClusterRouter.random((Cluster[])clusters);
    }

    @Bean(name={"clusterRouter"}, destroyMethod="close")
    @ConditionalOnMissingBean(value={ClusterRouter.class})
    @ConditionalOnProperty(prefix="ebatis.cluster", name={"round-robbin[0]"})
    public ClusterRouter roundRobbinClusterRouter() {
        Cluster[] clusters = (Cluster[])Stream.of(this.properties.getCluster().getRoundRobbin()).map(EbatisAutoConfiguration::toHttpHosts).map(Cluster::simple).toArray(Cluster[]::new);
        return ClusterRouter.roundRobbin((Cluster[])clusters);
    }

    @Bean(name={"clusterRouter"}, destroyMethod="close")
    @ConditionalOnMissingBean(value={ClusterRouter.class})
    @ConditionalOnProperty(prefix="ebatis.cluster", name={"weighted[0]"})
    public ClusterRouter weightedClusterRouter() {
        WeightedCluster[] clusters = (WeightedCluster[])Stream.of(this.properties.getCluster().getWeighted()).map(EbatisAutoConfiguration::toWeightedClusters).toArray(WeightedCluster[]::new);
        return ClusterRouter.weighted((WeightedCluster[])clusters);
    }

    @Configuration
    @Import(value={AutoConfiguredEasyMapperRegistrar.class})
    @ConditionalOnMissingBean(type={"io.manbang.ebatis.spring.annotation.EasyMapperRegistrar"})
    public static class EsMapperScannerNotFound
    implements InitializingBean {
        public void afterPropertiesSet() {
            log.debug("\u6ca1\u6709\u914d\u7f6e\u626b\u63cf @EnableEasyMapper\uff0c\u7531 EbatisAutoConfiguration \u81ea\u52a8\u914d\u7f6e\u5b8c\u6210");
        }
    }

    public static class AutoConfiguredEasyMapperRegistrar
    implements ImportBeanDefinitionRegistrar,
    BeanFactoryAware {
        private BeanFactory beanFactory;

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            if (!AutoConfigurationPackages.has((BeanFactory)this.beanFactory)) {
                log.warn("\u65e0\u6cd5\u786e\u5b9a EsMapper \u626b\u63cf\u8303\u56f4\uff0c\u81ea\u52a8 EsMapper \u7981\u7528\uff01\uff01\uff01");
                return;
            }
            log.info("\u81ea\u52a8\u626b\u63cf @EasyMapper \u6ce8\u89e3\u7684\u63a5\u53e3");
            List packages = AutoConfigurationPackages.get((BeanFactory)this.beanFactory);
            new EasyMapperBeanDefinitionScanner(registry, EbatisAutoConfiguration.DEFAULT_CLUSTER_ROUTER_NAME).scan(packages.toArray(new String[0]));
        }

        public void setBeanFactory(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }
    }

    public static class EsHost {
        private final String hostname;
        private final int port;

        public HttpHost toHttpHost() {
            return new HttpHost(this.hostname, this.port <= 0 ? 9200 : this.port);
        }

        public EsHost(String hostname, int port) {
            this.hostname = hostname;
            this.port = port;
        }

        public String getHostname() {
            return this.hostname;
        }

        public int getPort() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EsHost)) {
                return false;
            }
            EsHost other = (EsHost)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$hostname = this.getHostname();
            String other$hostname = other.getHostname();
            if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
                return false;
            }
            return this.getPort() == other.getPort();
        }

        protected boolean canEqual(Object other) {
            return other instanceof EsHost;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $hostname = this.getHostname();
            result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
            result = result * 59 + this.getPort();
            return result;
        }

        public String toString() {
            return "EbatisAutoConfiguration.EsHost(hostname=" + this.getHostname() + ", port=" + this.getPort() + ")";
        }
    }
}

