/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.sample.web.controller;

import io.manbang.ebatis.core.domain.Page;
import io.manbang.ebatis.core.domain.Pageable;
import io.manbang.ebatis.sample.mapper.OrderMapper;
import io.manbang.ebatis.sample.model.Order;
import io.manbang.ebatis.sample.model.OrderCondition;
import java.util.concurrent.TimeUnit;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@RestController
@RequestMapping(value={"/orders"})
public class OrderController {
    private final OrderMapper orderMapper;

    public OrderController(OrderMapper orderMapper) {
        this.orderMapper = orderMapper;
    }

    @PostMapping
    public Page<Order> search(@RequestBody OrderCondition condition, Pageable pageable) {
        return this.orderMapper.search(condition, pageable);
    }

    @GetMapping(value={"/{id}"})
    public DeferredResult<Order> findById(@PathVariable String id) {
        DeferredResult deferredResult = new DeferredResult(Long.valueOf(TimeUnit.SECONDS.toMillis(30L)));
        this.orderMapper.findById(id).whenComplete((order, throwable) -> {
            if (throwable == null) {
                deferredResult.setResult(order);
            } else {
                deferredResult.setErrorResult(throwable);
            }
        });
        return deferredResult;
    }
}

