/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.response;

import com.google.auto.service.AutoService;
import io.manbang.ebatis.core.domain.Page;
import io.manbang.ebatis.core.generic.GenericType;
import io.manbang.ebatis.core.meta.MetaUtils;
import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.meta.RequestType;
import io.manbang.ebatis.core.response.AbstractResponseExtractorProvider;
import io.manbang.ebatis.core.response.ArrayDocumentExtractor;
import io.manbang.ebatis.core.response.ArrayListSearchResponseExtractor;
import io.manbang.ebatis.core.response.ArrayMultiSearchResponseExtractor;
import io.manbang.ebatis.core.response.BoolArrayMultiSearchResponseExtractor;
import io.manbang.ebatis.core.response.BooleanArrayMultiSearchResponseExtractor;
import io.manbang.ebatis.core.response.BooleanListMultiSearchResponseExtractor;
import io.manbang.ebatis.core.response.DocumentExtractor;
import io.manbang.ebatis.core.response.DocumentMapper;
import io.manbang.ebatis.core.response.DocumentPageExtractor;
import io.manbang.ebatis.core.response.ListArraySearchResponseExtractor;
import io.manbang.ebatis.core.response.ListMultiSearchResponseExtractor;
import io.manbang.ebatis.core.response.PageArrayMultiSearchResponseExtractor;
import io.manbang.ebatis.core.response.PageMultiSearchResponseExtractor;
import io.manbang.ebatis.core.response.RawResponseExtractor;
import io.manbang.ebatis.core.response.ResponseExtractor;
import io.manbang.ebatis.core.response.ResponseExtractorProvider;
import io.manbang.ebatis.core.response.TotalHitsArrayMultiSearchResponseExtractor;
import io.manbang.ebatis.core.response.TotalHitsBasicArrayMultiSearchResponseExtractor;
import io.manbang.ebatis.core.response.TotalHitsListMultiSearchResponseExtractor;
import java.util.List;
import org.elasticsearch.action.search.MultiSearchResponse;

@AutoService(value={ResponseExtractorProvider.class})
public class MultiSearchResponseExtractorProvider
extends AbstractResponseExtractorProvider {
    public MultiSearchResponseExtractorProvider() {
        super(RequestType.MULTI_SEARCH);
    }

    @Override
    protected ResponseExtractor<?> getResponseExtractor(MethodMeta meta, GenericType genericType) {
        Class<?> resultType = genericType.resolve();
        if (List.class.isAssignableFrom(resultType)) {
            Class<?> entityClass = genericType.resolveGeneric(0);
            if (entityClass == Long.class) {
                return TotalHitsListMultiSearchResponseExtractor.INSTANCE;
            }
            if (entityClass == Boolean.class) {
                return BooleanListMultiSearchResponseExtractor.INSTANCE;
            }
            if (List.class.isAssignableFrom(entityClass)) {
                entityClass = genericType.resolveGeneric(0, 0);
                return new ListMultiSearchResponseExtractor(new DocumentExtractor(DocumentMapper.of(entityClass), Integer.MAX_VALUE));
            }
            if (Page.class.isAssignableFrom(entityClass)) {
                entityClass = genericType.resolveGeneric(0, 0);
                return new PageMultiSearchResponseExtractor(new DocumentPageExtractor(DocumentMapper.of(entityClass)));
            }
            if (entityClass.isArray()) {
                if ((entityClass = entityClass.getComponentType()) == Long.class || entityClass == Long.TYPE) {
                    return TotalHitsArrayMultiSearchResponseExtractor.INSTANCE;
                }
                if (!MetaUtils.isBasic(entityClass)) {
                    return new ListArraySearchResponseExtractor(new ArrayDocumentExtractor(DocumentMapper.of(entityClass), Integer.MAX_VALUE));
                }
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301");
            }
            throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301\u7684\u8fd4\u56de\u503c\u7c7b\u578b");
        }
        if (resultType.isArray()) {
            Class<?> entityClass = genericType.resolveGeneric(0);
            if (Page.class.isAssignableFrom(entityClass)) {
                entityClass = genericType.resolveGeneric(0, 0);
                return new PageArrayMultiSearchResponseExtractor(new DocumentPageExtractor(DocumentMapper.of(entityClass)));
            }
            if (entityClass.isArray()) {
                entityClass = genericType.resolveGeneric(0, 0);
                return new ArrayMultiSearchResponseExtractor(new ArrayDocumentExtractor(DocumentMapper.of(entityClass), Integer.MAX_VALUE), entityClass);
            }
            if (List.class.isAssignableFrom(entityClass)) {
                entityClass = genericType.resolveGeneric(0, 0);
                return new ArrayListSearchResponseExtractor(new DocumentExtractor(DocumentMapper.of(entityClass), Integer.MAX_VALUE));
            }
            if (entityClass == Long.class) {
                return TotalHitsArrayMultiSearchResponseExtractor.INSTANCE;
            }
            if (entityClass == Long.TYPE) {
                return TotalHitsBasicArrayMultiSearchResponseExtractor.INSTANCE;
            }
            if (entityClass == Boolean.class) {
                return BooleanArrayMultiSearchResponseExtractor.INSTANCE;
            }
            if (entityClass == Boolean.TYPE) {
                return BoolArrayMultiSearchResponseExtractor.INSTANCE;
            }
            throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301\u7684\u8fd4\u56de\u503c\u7c7b\u578b");
        }
        if (MultiSearchResponse.class == resultType) {
            return RawResponseExtractor.INSTANCE;
        }
        throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301\u7684\u8fd4\u56de\u503c\u7c7b\u578b");
    }
}

