/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.request;

import io.manbang.ebatis.core.generic.GenericType;
import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.request.RequestFactory;
import java.lang.annotation.Annotation;
import java.util.function.Consumer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.ActionRequest;

public abstract class AbstractRequestFactory<A extends Annotation, R extends ActionRequest>
implements RequestFactory<R> {
    private final Class<? extends Annotation> requestAnnotationClass = GenericType.forType(this.getClass()).as(AbstractRequestFactory.class).resolveGeneric(0);

    protected AbstractRequestFactory() {
    }

    @Override
    public final R create(MethodMeta meta, Object ... args) {
        R request = this.doCreate(meta, args);
        Object requestAnnotation = meta.getRequestAnnotation();
        if (this.requestAnnotationClass.isInstance(requestAnnotation)) {
            this.setAnnotationMeta(request, meta.getRequestAnnotation());
        }
        return request;
    }

    protected void setTypeIfNecessary(MethodMeta meta, Consumer<String> consumer) {
        if (StringUtils.isNotBlank((CharSequence)meta.getType())) {
            consumer.accept(meta.getType());
        }
    }

    protected void setTypesIfNecessary(MethodMeta meta, Consumer<String[]> consumer) {
        if (ArrayUtils.isNotEmpty((Object[])meta.getTypes())) {
            consumer.accept(meta.getTypes());
        }
    }

    protected abstract void setAnnotationMeta(R var1, A var2);

    protected abstract R doCreate(MethodMeta var1, Object[] var2);
}

