/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.domain;

import io.manbang.ebatis.core.domain.PageImpl;
import io.manbang.ebatis.core.domain.Pageable;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public interface Page<T>
extends Iterable<T> {
    public static <T> Page<T> of(long total, List<T> content, Pageable pageable) {
        return new PageImpl<T>(total, content, pageable);
    }

    public int getTotalPage();

    public long getTotal();

    public Pageable getPageable();

    public List<T> getContent();

    @Override
    default public Iterator<T> iterator() {
        return this.getContent().iterator();
    }

    default public boolean hasNext() {
        return this.getTotalPage() > this.getPageable().getPage() + 1;
    }

    default public int getTotalElement() {
        return this.getContent().size();
    }

    default public boolean isEmpty() {
        return this.getContent().isEmpty();
    }

    default public Stream<T> stream() {
        return this.getContent().stream();
    }

    default public Stream<T> parallelStream() {
        return this.getContent().parallelStream();
    }
}

