/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import io.manbang.ebatis.core.annotation.Ignore;
import java.util.Objects;

public class ObjectMapperHolder {
    private static final ThreadLocal<ObjectMapper> OBJECT_MAPPERS = ThreadLocal.withInitial(() -> {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){

            public boolean hasIgnoreMarker(AnnotatedMember m) {
                Ignore ann = (Ignore)this._findAnnotation((Annotated)m, Ignore.class);
                return Objects.nonNull(ann) || super.hasIgnoreMarker(m);
            }
        });
        return mapper;
    });

    private ObjectMapperHolder() {
        throw new UnsupportedOperationException();
    }

    public static ObjectMapper objectMapper() {
        return OBJECT_MAPPERS.get();
    }

    public static void remove() {
        OBJECT_MAPPERS.remove();
    }
}

