/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.common;

import io.manbang.ebatis.core.meta.AnnotationAttribute;
import io.manbang.ebatis.core.meta.AnnotationMeta;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;

public class AnnotationUtils {
    private AnnotationUtils() {
        throw new UnsupportedOperationException();
    }

    public static <A> Optional<A> findAttributeAnnotation(Annotation annotation, Class<A> attributeClass) {
        if (annotation == null || attributeClass == null) {
            return Optional.empty();
        }
        return AnnotationMeta.of(annotation).getAttributes().stream().filter(AnnotationAttribute::isAnnotation).filter(a -> attributeClass == a.getAttributeType()).findFirst().map(a -> a.getFirstValue(annotation));
    }

    public static <A> Optional<A> findFirstAttribute(Annotation annotation, Class<A> attributeClass) {
        if (annotation == null || attributeClass == null) {
            return Optional.empty();
        }
        return AnnotationMeta.of(annotation).getAttributes().stream().filter(a -> attributeClass == a.getAttributeType()).findFirst().map(a -> a.getFirstValue(annotation));
    }

    public static <A> Optional<A> findAttribute(Annotation annotation, String attributeName) {
        if (annotation == null || attributeName == null) {
            return Optional.empty();
        }
        return AnnotationMeta.of(annotation).getAttributes().stream().filter(a -> Objects.equals(attributeName, a.getName())).findFirst().map(a -> a.getValue(annotation));
    }

    public static <A> Optional<A> findAttribute(Annotation annotation, Class<A> attributeType) {
        if (annotation == null || attributeType == null) {
            return Optional.empty();
        }
        return AnnotationMeta.of(annotation).getAttributes().stream().filter(a -> attributeType == a.getAttributeType()).findFirst().map(a -> a.getValue(annotation));
    }
}

