/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.request;

import io.manbang.ebatis.core.annotation.MultiGet;
import io.manbang.ebatis.core.exception.ConditionNotSupportException;
import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.meta.ParameterMeta;
import io.manbang.ebatis.core.provider.IdProvider;
import io.manbang.ebatis.core.provider.RoutingProvider;
import io.manbang.ebatis.core.provider.VersionProvider;
import io.manbang.ebatis.core.request.AbstractRequestFactory;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.get.MultiGetRequest;

class MultiGetRequestFactory
extends AbstractRequestFactory<MultiGet, MultiGetRequest> {
    static final MultiGetRequestFactory INSTANCE = new MultiGetRequestFactory();

    private MultiGetRequestFactory() {
    }

    @Override
    protected void setAnnotationMeta(MultiGetRequest request, MultiGet multiGet) {
        request.realtime(multiGet.realtime()).refresh(multiGet.refresh()).preference(StringUtils.trimToNull((String)multiGet.preference()));
    }

    @Override
    protected MultiGetRequest doCreate(MethodMeta meta, Object[] args) {
        Object[] conditions;
        ParameterMeta parameterMeta = meta.getConditionParameter();
        Object arg = parameterMeta.getValue(args);
        if (parameterMeta.isCollection()) {
            Collection collection = (Collection)arg;
            conditions = collection.toArray();
        } else {
            conditions = parameterMeta.isArray() ? (Object[])arg : new Object[]{arg};
        }
        MultiGetRequest request = new MultiGetRequest();
        for (Object condition : conditions) {
            if (parameterMeta.isBasic()) {
                request.add(new MultiGetRequest.Item(meta.getIndex(), StringUtils.trimToNull((String)meta.getType()), String.valueOf(condition)));
                continue;
            }
            if (condition instanceof IdProvider) {
                MultiGetRequest.Item item = new MultiGetRequest.Item(meta.getIndex(), StringUtils.trimToNull((String)meta.getType()), ((IdProvider)condition).getId());
                if (condition instanceof VersionProvider) {
                    item.version(((VersionProvider)condition).getVersion());
                }
                if (condition instanceof RoutingProvider) {
                    item.routing(((RoutingProvider)condition).getRouting());
                }
                request.add(item);
                continue;
            }
            throw new ConditionNotSupportException(meta.toString());
        }
        return request;
    }
}

