/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.domain;

import io.manbang.ebatis.core.domain.DefaultRange;
import org.elasticsearch.index.query.QueryBuilder;

public interface Range<T extends Comparable<T>> {
    public static <T extends Comparable<T>> Range<T> of(T min, T max) {
        return new DefaultRange<T>(min, max);
    }

    public static <T extends Comparable<T>> Range<T> lt(T max) {
        return new DefaultRange<Object>(null, max).openRight();
    }

    public static <T extends Comparable<T>> Range<T> le(T max) {
        return new DefaultRange<Object>(null, max).closeRight();
    }

    public static <T extends Comparable<T>> Range<T> gt(T min) {
        return new DefaultRange<Object>(min, null).openLeft();
    }

    public static <T extends Comparable<T>> Range<T> ge(T min) {
        return new DefaultRange<Object>(min, null).closeLeft();
    }

    public Range<T> setName(String var1);

    public Range<T> closeLeft();

    public Range<T> openLeft();

    public Range<T> closeRight();

    public Range<T> openRight();

    public Range<T> intersects();

    public Range<T> disjoint();

    public Range<T> within();

    public Range<T> contains();

    public QueryBuilder toBuilder();
}

