/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.domain;

import io.manbang.ebatis.core.domain.Script;
import io.manbang.ebatis.core.meta.ClassMeta;
import io.manbang.ebatis.core.meta.ConditionMeta;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

abstract class AbstractScript
implements Script {
    private static final String DEFAULT_LANG = "painless";
    private final String idOrCode;
    private Map<String, Object> params;
    private String lang;
    private Map<String, String> options;

    protected AbstractScript(String idOrCode, Object params) {
        this.idOrCode = idOrCode;
        this.params = this.toMap(params);
        this.lang = DEFAULT_LANG;
        this.options = Collections.emptyMap();
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    @Override
    public Map<String, String> getOptions() {
        return this.options;
    }

    @Override
    public void setParams(Object params) {
        this.params = this.toMap(params);
    }

    @Override
    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    private Map<String, Object> toMap(Object obj) {
        if (Objects.isNull(obj)) {
            return Collections.emptyMap();
        }
        return this.beanToMap(obj);
    }

    private Map<String, Object> beanToMap(Object obj) {
        if (obj instanceof Map) {
            return (Map)obj;
        }
        ClassMeta meta = ClassMeta.of(obj.getClass());
        return meta.getFieldMetas().stream().collect(Collectors.toMap(ConditionMeta::getName, e -> e.getValue(obj)));
    }

    public String getIdOrCode() {
        return this.idOrCode;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    @Override
    public void setLang(String lang) {
        this.lang = lang;
    }

    @Override
    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractScript)) {
            return false;
        }
        AbstractScript other = (AbstractScript)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$idOrCode = this.getIdOrCode();
        String other$idOrCode = other.getIdOrCode();
        if (this$idOrCode == null ? other$idOrCode != null : !this$idOrCode.equals(other$idOrCode)) {
            return false;
        }
        Map<String, Object> this$params = this.getParams();
        Map<String, Object> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        String this$lang = this.getLang();
        String other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) {
            return false;
        }
        Map<String, String> this$options = this.getOptions();
        Map<String, String> other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractScript;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $idOrCode = this.getIdOrCode();
        result = result * 59 + ($idOrCode == null ? 43 : $idOrCode.hashCode());
        Map<String, Object> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        String $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        Map<String, String> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractScript(idOrCode=" + this.getIdOrCode() + ", params=" + this.getParams() + ", lang=" + this.getLang() + ", options=" + this.getOptions() + ")";
    }
}

