/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.cluster;

import io.manbang.ebatis.core.cluster.Credentials;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.util.Args;

class BasicCredentials
implements Credentials {
    private final String username;
    private final String password;

    public BasicCredentials(String username, String password) {
        Args.notNull((Object)username, (String)"username");
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public CredentialsProvider toCredentialsProvider() {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (org.apache.http.auth.Credentials)new UsernamePasswordCredentials(this.username, this.password));
        return credentialsProvider;
    }
}

