/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.generic;

import io.manbang.ebatis.core.generic.GenericType;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;

class DefaultGenericType
implements GenericType {
    private static final GenericType NONE = new DefaultGenericType(null);
    private final Type type;

    DefaultGenericType(Type type) {
        this.type = type;
    }

    @Override
    public GenericType as(Class<?> type) {
        if (this.type == null) {
            return NONE;
        }
        Type currentType = this.type;
        if (type == currentType) {
            return this;
        }
        if (currentType instanceof Class) {
            Type[] genericInterfaces;
            Type superclass = ((Class)currentType).getGenericSuperclass();
            GenericType genericType = GenericType.forType(superclass);
            if (superclass == type) {
                return genericType;
            }
            if ((genericType = genericType.as(type)) != null) {
                return genericType;
            }
            for (Type genericInterface : genericInterfaces = ((Class)currentType).getGenericInterfaces()) {
                genericType = GenericType.forType(genericInterface);
                if (genericInterface == type) {
                    return genericType;
                }
                if ((genericType = genericType.as(type)) == null) continue;
                return genericType;
            }
        } else {
            Type genericComponentType;
            if (currentType instanceof ParameterizedType) {
                Type rawType = ((ParameterizedType)currentType).getRawType();
                if (rawType == type) {
                    return this;
                }
                return GenericType.forType(rawType).as(type);
            }
            if (currentType instanceof GenericArrayType && (genericComponentType = ((GenericArrayType)currentType).getGenericComponentType()) == type) {
                return this;
            }
        }
        return NONE;
    }

    @Override
    public Optional<Class<?>> resolveGenericOptional(int ... indices) {
        Class<?> currentType = this.type;
        for (int index : indices) {
            if (currentType instanceof ParameterizedType) {
                currentType = ((ParameterizedType)((Object)currentType)).getActualTypeArguments()[index];
                continue;
            }
            if (currentType instanceof GenericArrayType) {
                currentType = ((GenericArrayType)((Object)currentType)).getGenericComponentType();
                continue;
            }
            if (!(currentType instanceof Class) || !((Class)currentType).isArray()) continue;
            currentType = ((Class)currentType).getComponentType();
        }
        if (currentType instanceof Class) {
            return Optional.of((Class)currentType);
        }
        if (currentType instanceof ParameterizedType) {
            return Optional.ofNullable((Class)((ParameterizedType)((Object)currentType)).getRawType());
        }
        return Optional.empty();
    }

    @Override
    public Optional<Class<?>> resolveOptional() {
        if (this.type instanceof Class) {
            return Optional.of((Class)this.type);
        }
        if (this.type instanceof ParameterizedType) {
            return Optional.ofNullable((Class)((ParameterizedType)this.type).getRawType());
        }
        if (this.type instanceof GenericArrayType) {
            Type genericComponentType = ((GenericArrayType)this.type).getGenericComponentType();
            return GenericType.forType(genericComponentType).resolveOptional().map(clazz -> Array.newInstance(clazz, 0).getClass());
        }
        return Optional.empty();
    }

    @Override
    public GenericType resolveType(int ... indices) {
        Type currentType = this.type;
        for (int index : indices) {
            if (currentType instanceof ParameterizedType) {
                currentType = ((ParameterizedType)currentType).getActualTypeArguments()[index];
                continue;
            }
            if (!(currentType instanceof GenericArrayType)) continue;
            currentType = ((GenericArrayType)currentType).getGenericComponentType();
        }
        return GenericType.forType(currentType);
    }
}

