/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.response;

import io.manbang.ebatis.core.response.DocumentMapper;
import io.manbang.ebatis.core.response.SearchResponseExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;

public class DocumentExtractor<T>
implements SearchResponseExtractor<List<T>> {
    private final DocumentMapper<T> documentMapper;
    private final int documentsExpected;

    public DocumentExtractor(DocumentMapper<T> documentMapper, int documentsExpected) {
        this.documentMapper = documentMapper;
        this.documentsExpected = documentsExpected;
    }

    @Override
    public List<T> doExtractData(SearchResponse response) {
        SearchHit[] hits = response.getHits().getHits();
        int hitCount = hits.length;
        int count = Math.min(this.documentsExpected, hitCount);
        ArrayList<T> result = new ArrayList<T>(count);
        for (int i = 0; i < count; ++i) {
            result.add(this.documentMapper.mapRow(hits[i], i + 1));
        }
        return result;
    }

    @Override
    public List<T> empty() {
        return Collections.emptyList();
    }
}

